/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplgroup APL2 V1.0.0 ************************************************
* Called from aplwksp to do )GROUP.                                    *
***********************************************************************/
#define INCLUDES STRING+APLTOKEN+APLCB+TREE
#include "includes.h"
void aplgroup(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to char immediately after right parenthesis */
char *cpend; /* Pointer to end of command text */
{
	Aplgrouq; Aplgrous; Execmsg; Execpars; Execpop; Treenode;
	extern int aplerr;
	Apltoken grphdr=NULL,nametok,tok,tokhdr;
	int cplen,cols=0,rows=0;
	Avlnode p;
	char *nameptr;
	Aplcb namecb=NULL;

	cplen=cpend-cp;
	for (tok = tokhdr = execpars(cp,cplen);
		tok != NULL && aplerr == 0;
		tok = tok->token_queue.token_next_ptr) {
		nametok = tok; /* save potential group name token */
		if (tok->token_code != OPERAND_TOKEN)
			aplerr = 58; /* syntax error */
	}
	if (tokhdr == NULL)
		aplerr = 58; /* syntax error */
	for (;;) { /* allow use of break */
		if (aplerr) break;
		nameptr = nametok->token_ptr.token_string;
		if (NULL != (p = treenode(nameptr)) && 
			NULL != (namecb = p->avlleaf) &&
			!(namecb->aplflags & APLGROUP))
			aplerr = 118; /* group name already in use */
		for (tok = tokhdr; tok != nametok && aplerr == 0;
			tok = tok->token_queue.token_next_ptr)
			if (0 == strcmp(nameptr,tok->token_ptr.token_string))
				if (namecb == NULL)
					aplerr = 119; /* recursive name undefined */
				else /* add existing group to new group */
					aplgrouq(&grphdr,&rows,&cols,namecb);
			else /* add new name to new group */
				aplgrour(&grphdr,&rows,&cols,
					tok->token_ptr.token_string,
					strlen(tok->token_ptr.token_string));
		if (aplerr == 0)
			aplgrous(&grphdr,rows,cols,nameptr); /* finish group */
		break;
	}
	execpop(&tokhdr); /* pop and free tokens on stack */
	execpop(&grphdr); /* pop and free tokens on stack */
}
