/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledqu APL2 V1.0.0 *************************************************
* Called from aplediy to display statements, e.g. [L].                 *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLMEM+APLTOKEN+STRING+TREE
#include "includes.h"
void apledqu(e,cp,stmtlen,tokcnt)
Apledst e;		/* Edit common area.					*/
char *cp;				/* Pointer to current input.				*/
int stmtlen;			/* Length of current input.				*/
int tokcnt;			/* Tokens remaining to process.			*/
{
	Apledno; Apledpf; Apledpr; Execmsg; Execqfxe; Value;
	extern int aplerr;
	Aplcb in;
	Apltoken curtok,tokhdr;
	Apled ed;
	double disno;
	int tempsave;
	char *line,pf[50];

	tokhdr = *(e->fp->functokp); /* token list from temp. hdr. */
	if (tokcnt > 4 || tokhdr->token_code != RIGHT_BRACKET) {
		execmsg(cp,stmtlen,0,"Bad syntax for DEL display.");
		return;
	}
	if (tokcnt == 3)
		disno = 0.0; /* wants display of everything */
	else {
		disno = apledno(tokhdr + tokcnt - 2,cp,stmtlen); /* get number */
		if (disno == -1.0)
			return; /* apledno will have printed message */
	}
	for (ed = e->edhdr; ed != NULL && disno > ed->apledst;
		ed = ed->aplednxt);
	if (ed == NULL) {
		execmsg(cp,stmtlen,0,"Statement to display not found.");
		return;
	}
	for (e->cured = ed; e->cured != NULL; e->cured = e->cured->aplednxt) {
		line = apledpr(e->cured,1); /* Go format statement. */
		execmsg(line,strlen(line),0,NULL); /* Now print it. */
		if (tokcnt > 3) { /* display single statement only */
			e->aplstinc = 0.0; /* display this stmtno next */
			return;
		}
	}
	e->aplstinc = 1.0;
	e->cured = e->edlst;
	apledpf(0.0,pf,1); /* format trailing DEL */
	execmsg(pf,strlen(pf),0,NULL); /* Now print it. */
}
