/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* apledpq APL2 V1.0.0 *************************************************
* Called from apledps when the current token is for one of the quad    *
* variables.                                                           *
***********************************************************************/
#define INCLUDES STDIO+STRING+APLCB+APLCHDEF+APLTOKEN+APLED
#include "includes.h"
void apledpq(code,line)
int code;			/* Quad code	*/
char *line;		/* String in which to store formatted stmt. */
{
	char *codechar();
	int i,j;

	switch(code) {
		case QUAD_AI: i = APL_A; j = APL_I; break;
		case QUAD_AV: i = APL_A; j = APL_V; break;
		case QUAD_CR: i = APL_C; j = APL_R; break;
		case QUAD_CT: i = APL_C; j = APL_T; break;
		case QUAD_DL: i = APL_D; j = APL_L; break;
		case QUAD_EA: i = APL_E; j = APL_A; break;
		case QUAD_EX: i = APL_E; j = APL_X; break;
		case QUAD_FX: i = APL_F; j = APL_X; break;
		case QUAD_HT: i = APL_H; j = APL_T; break;
		case QUAD_IO: i = APL_I; j = APL_O; break;
		case QUAD_LC: i = APL_L; j = APL_C; break;
		case QUAD_LX: i = APL_L; j = APL_X; break;
		case QUAD_NC: i = APL_N; j = APL_C; break;
		case QUAD_NL: i = APL_N; j = APL_L; break;
		case QUAD_PP: i = APL_P; j = APL_P; break;
		case QUAD_PW: i = APL_P; j = APL_W; break;
		case QUAD_RL: i = APL_R; j = APL_L; break;
		case QUAD_TC: i = APL_T; j = APL_C; break;
		case QUAD_TS: i = APL_T; j = APL_S; break;
		case QUAD_TT: i = APL_T; j = APL_T; break;
		case QUAD_UL: i = APL_U; j = APL_L; break;
		case QUAD_WA: i = APL_W; j = APL_A; break;
	} /* end switch */
	strcat(line,codechar(QUAD));
	strcat(line,codechar(i));
	strcat(line,codechar(j));
	strcat(line," ");
}
