/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplednw APL2 V1.0.0 *************************************************
* Called from apledmd to add or replace a statement during DEL editing,*
* or to reposition to a specified statement number.                    * 
***********************************************************************/
#define INCLUDES APLMEM+APLCHDEF+APLTOKEN+APLFUNCI+APLED
#include "includes.h"
void aplednw(e,newno,cp,stmtlen,cpn,tokcnt)
Apledst e;	/* Edit common area.					*/
double newno;	/* new statement number.					*/
char *cp;		/* Pointer to current input.				*/
int stmtlen;	/* Length of current input.				*/
char *cpn;	/* Ptr to cap null, if stmt is comment.		*/
int tokcnt;	/* Count of tokens to be processed. Not zero.*/
{
	Apledcm; Apledix; Execqfxc; Execqfxe; Expungf;
	Apltoken newhdr,newtok,tokhdr;
	double oldno;
	int i;

	tokhdr = *(e->fp->functokp); /* token list from temp. hdr. */
	if (tokcnt) { /* it is add or replacement */
		newhdr = newtok = malloc(tokcnt * sizeof(struct apltoken));
		for ( i = tokcnt; i > 0; i--)
			newtok = execqfxc(newtok,tokhdr++); /* copy next token */
		if (e->cured != NULL && e->cured->apledst == newno) {
			if (e->cured->apledtm) /* it is replacement */
				expungf(e->cured->apledhd, e->cured->apledcn);
					/* free old tokens */
			e->cured->apledhd = newhdr; /*new tokens*/
			e->cured->apledcn = tokcnt; /*new tokcnt*/
			e->cured->apledtm = 1; /* mark for later deletion */
		}
		else /* it is addition */
			e->cured = apledix(e, e->cured, newhdr, tokcnt,
				newno, 1);
		if (e->cured->apledhd->token_code == CAP_NULL)
			apledcm(e->cured, cpn, stmtlen - (cpn - cp));
	}
	else { /* it is reposition */
		oldno = (e->cured == NULL) ? 0.0 : e->cured->apledst;
		if (oldno == newno)
			e->aplstinc = 0.0; /* set increment for replacement */
		else
			e->aplstinc = newno - oldno; /* set for add */
	}
}
