/*Copyright (C) 1992, 1995 by Thomas Glen Smith.	All Rights Reserved.*/
/* apledno APL2 V1.0.0 *************************************************
* Called by apledmd, apledqu, and apleddl.                             *
* Called during DEL edit processing to obtain a numeric value from a	 *
* parsed token. Error messages will be printed, and a -1.0 will be	 *
* returned if a proper value cannot be obtained.	Only positive values *
* are considered proper.										 *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN
#include "includes.h"
double apledno(tok,cp,stmtlen)
Apltoken tok;	/* Token from which number is to be obtained.*/
char *cp;		/* Pointer to current input.				*/
int stmtlen;	/* Length of current input.				*/
{
	Dblne; Execmsg; Value;
	extern int aplerr;
	Aplcb in;
	double ret;
	int tempsave;

	if (tok->token_code != VECTOR_TOKEN) {
		execmsg(cp,stmtlen,0,"Number not where expected in DEL edit.");
		return(-1.0);
	}
	in = tok->token_ptr.token_vector;
	in->aplflags -= (tempsave = in->aplflags & APLTEMP);
	ret = value(in); /* number */
	in->aplflags += tempsave; /* restore temp indicator */
	if (aplerr) {
		execmsg(cp,stmtlen,0,NULL); /* print error message */
		aplerr = 0;
		return(-1.0);
	}
	if (ret < 0.0) {
		execmsg(cp,stmtlen,0,"Invalid negative number in DEL edit.");
		return(-1.0);
	}
	return(ret);
}
