/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledmd APL2 V1.0.0 *************************************************
* Called from aplediy to modify a statement.                           *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLTOKEN+STRING
#include "includes.h"
void apledmd(e,cp,stmtlen,cpn,tokcnt)
Apledst e;		/* Edit common area.					*/
char *cp;				/* Pointer to current input.				*/
int stmtlen;			/* Length of current input.				*/
char *cpn;			/* Ptr to cap null, if stmt is comment.		*/
int tokcnt;			/* Tokens remaining to process.			*/
{
	Apledme; Apledmf; Apledno; Aplednw; Apledpr; Execmsg; Execqfxe;
	Expungf; Value;
	extern int aplerr;
	Aplcb in;
	Apltoken curtok,tokhdr;
	Apled ed,wk;
	double newno;
	int off;
	char *line;

	tokhdr = *(e->fp->functokp); /* token list from temp. hdr. */
	newno = apledno(tokhdr + tokcnt - 2,cp,stmtlen);
	if (-1.0 == newno)
		return; /* apledno will have printed error message */
	ed = NULL;
	for (wk = e->edhdr; wk != NULL && newno >= wk->apledst;
		wk = wk->aplednxt) ed = wk;
	if (NULL != execqfxe(tokhdr + tokcnt - 3,RIGHT_BRACKET,0)) {
		e->cured = ed; /* it is e.g.  [1] ... */
		aplednw(e,newno,cp,stmtlen,cpn,tokcnt-3);
		return;
	}
	if (tokcnt > 5) {
		execmsg(cp,stmtlen,0,"Bad syntax for DEL modify.");
		return;
	}
	if (ed == NULL) {
		execmsg(cp,stmtlen,0,"Statement to modify not found.");
		return;
	}
	if (tokcnt == 4)
		if (NULL != execqfxe(tokhdr + tokcnt - 3,QUAD,0))
			off = 1; /* offset to place cursor below statement */
		else
			off = -1; /* indicate it is new edit */
	else {
		newno = apledno(tokhdr + tokcnt - 4,cp,stmtlen);
		if (-1.0 == newno)
			return; /* apledno will have printed error message */
		off = newno;
	}
	line = apledpr(ed,0); /* go produce statement text for edit */
	if (off >= 0)
		apledme(e,line,off); /* go display and edit line */
	else
		apledmf(e,line,0,1);
}
