/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplediu APL2 V1.0.0 *************************************************
* Called from apledit after it has determined the initial input for    *
* the DEL editor is not a valid function header, unless it is a        *
* niladic with no return, or it's an existing user-defined function to *
* be edited.                                                           *
***********************************************************************/
#define INCLUDES APLCB+APLED+APLFUNCI+APLTOKEN+TREE
#include "includes.h"
void aplediu(e,cp,stmtlen)
Apledst e;			/* Edit common area.				*/
char *cp;					/* Pointer to current input.			*/
int stmtlen;				/* Length of current input.			*/
{
	Apledcl; Aplediv; Aplediw; Aplediy; Aplediz; Execqfxe; Treenode;
	extern int aplerr;
	Aplcb wrk;
	Aplfunc fun;
	Apltoken curtok,tokhdr;
	Avlnode p;
	int tokcnt;

	aplerr = 0; /* reset */
	tokcnt = *(e->fp->functokc); /* token cnt from temp. hdr.*/
	tokhdr = *(e->fp->functokp); /* token list from temp. hdr. */
	curtok = execqfxe(tokhdr + --tokcnt,OPERAND_TOKEN,114);
	if (aplerr) return; /* didn't get token type expected */
	if (NULL == (p = treenode(curtok->token_ptr.token_string)) ||
		NULL == (wrk = p->avlleaf)) {
		aplediv(e); /* go edit new niladic w/o return */
		return;
	}
	if (!(wrk->aplflags & APLFUNC)) {
		aplerr = 115; /* name in use */
		return;
	}
	fun = p->avlleaf; /* point to function description */
	aplediw(e,fun); /* prepare function for editing */
	if (tokcnt == 0)
		apledcl(e); /* free name token */
	else if (aplerr == 0)
		aplediy(e,cp,stmtlen,NULL,tokcnt); /* process input */
	if (aplerr == 0 && e->delptr == NULL)
		aplediz(e); /* get more input */
}
