/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledfm APL2 V1.0.0 *************************************************
* Called from e.g. aplediz to format a statement number in a printable *
* string, surrounded in brackets, padded with blanks to 10 characters. *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+STDIO+STRING
#include "includes.h"
char *apledfm(stmtno)
double stmtno; /* statement number to be formatted */
{
	Codechar; Endoper; Form; Scalar;
	extern int aplerr;
	Aplcb wrk;
	char *str;
	static char line[20];
	int i;

	line[0]='\0'; /* start out with a null string */
	wrk = form(NULL,scalar(stmtno)); /* format stmt no */
	sprintf(line,"%s%s%s ",codechar(LEFT_BRACKET),wrk->aplptr.aplchar,
		codechar(RIGHT_BRACKET));
	endoper(wrk);
	if ( 10 > (i = strlen(line))) { /* pad w/blanks to 10 chars */
		while ( 10 > i)
			line[i++] = ' ';
		line[i] = '\0';
	}
	return(line);
}
