/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplcpyd APL2 V1.0.0 *************************************************
* Called from aplcpyc when the object just copied was a group list,    *
* aplcpyd will copy all the items listed.                              *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+TREE
#include "includes.h"
void aplcpyd(fromtree,rite,pcopy)
struct treelist *fromtree;	/* Root of tree to copy from. */
Aplcb rite;			/* APL variable, group list. */
int pcopy;				/* 0 = )copy, 1 = )pcopy. */
{
	Aplcpya; Aplname; Chrcopy; Execmsg; Namelen;
	extern int aplerr;
	char *cp,*s,*wrk;
	int cols,i,k,rows;

	if (0 == rite->aplcount)
		return; /* nothing to copy */
	if (rite->aplrank == 2) {
		rows = *(rite->apldim);
		cols = *(rite->apldim + 1);
	}
	else {
		rows = 1;
		cols = rite->aplcount;
	}
	wrk = malloc(cols+1); /* name buffer */
	if (wrk == NULL) return; /* out of memory */
	for (i = 0; i < rows; i++) { /* once for each row in list */
		if (0 == (k = namelen(rite->aplptr.aplchar,cols,i,&s)))
			execmsg(s,cols,cols,"not copied");
		else {
			cp = chrcopy(wrk,s,k,1); /* copy name */
			*cp = '\0'; /* delimit */
			aplcpya(fromtree,wrk,pcopy); /* copy into workspace */
		}
	}
	free(wrk);
}
