/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplcpyc APL2 V1.0.0 *************************************************
* Called from aplcpya and aplcbyb to copy an item to the trunk of the  *
* tree pointed to by global treehdr.                                   *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+TREE
#include "includes.h"
void aplcpyc(fromtree,name,rite,pcopy)
Treelist fromtree;	/* Root of tree to copy from. */
char *name;				/* Name. */
void *rite;				/* APL variable/function to copy from */
int pcopy;				/* 0 = )copy, 1 = )pcopy. */
{
	Aplcpyd; Assign; Endoper; Execmsg; Execqfx; Treenode;
	extern int aplerr;
	Avlnode p;

	p = treenode(name); /* Does name already exist? */
	if (p != NULL && p->avlleaf != NULL) 
		if (pcopy) { /* protected copy - don't replace */
			execmsg(name,strlen(name),strlen(name),"not copied");
			return;
		}
		else {
			leafdel(p->avlleaf); /* delete existing leaf */
			p->avlleaf = NULL; 
		}
	if (((Aplcb) rite)->aplflags & APLFUNC)
		endoper(execqfx(
			((Aplfunc) rite)->functext)); /* function */
	else {
		rite = assign(name,rite); /* assign copies APL Variable */ 
		if (((Aplcb) rite)->aplflags & APLGROUP)
			aplcpyd(fromtree,rite,pcopy); /* copy group */
	}
}
