/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplcpya APL2 V1.0.0 *************************************************
* Called from aplcpy to copy an object from one workspace to another.  *
* The roots for the trees to copy from and to are respectively pointed *
* to by global treehdr and argument totree.                           *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+STRING+TREE
#include "includes.h"
void aplcpya(fromtree,name,pcopy)
Treelist fromtree;	/* Root of tree to copy from. */
char *name;				/* Name of object to copy. */
int pcopy;				/* 0 = )copy, 1 = )pcopy. */
{
	Aplcpyc; Avlsrch; Execmsg;
	extern	int aplerr;
	Aplcb leaf;
	Avlnode p;
	Treelist symp;

	for (symp = fromtree ;; symp = symp->treenext) {
		p = avlsrch(symp->avlhdr, name); /* look for name */
		if (p != NULL) break; /* found */
		if (symp->treenext == NULL) break; /* not found */
	}
	leaf = (p == NULL) ? NULL : p->avlleaf;
	if (leaf == NULL)
		execmsg(name,strlen(name),strlen(name),"not found");
	else
		aplcpyc(fromtree,name,leaf,pcopy); /* copy item */
}
