/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplcpy APL2 V1.0.0 **************************************************
* Called from aplwksp to do )COPY.                                     *
***********************************************************************/
#define MAXNAME 130
#define INCLUDES APLCB+APLTOKEN+STDIO+STRING+TREE
#include "includes.h"
void aplcpy(rite,cp,cpend,pcopy)
Aplcb rite;	/* Aplcb for command text. */
char *cp;			/* Pointer to char after )COPY in command text. */
char *cpend;		/* Pointer to end of command text. */
int pcopy;		/* 0 = )copy, 1 = )pcopy. */
{
	Aplclean; Aplcpya; Aplcpyb; Aplloae; Execpars; Execpop;
	extern	int aplerr;
	extern	char *aplfile;	char *savfile;
	extern	double fuzz;	double savfuzz;
	extern	int indxorg;	int savxorg;
	extern	void *treehdr;	void *savtree;
	Apltoken tok,tokhdr;
	char name[MAXNAME];
	Treelist fromtree,totree;

	savfile = aplfile;
	aplfile = NULL;
	savfuzz = fuzz;
	savtree = treehdr;
	treehdr = NULL;
	savxorg = indxorg;
	sscanf(cp,"%s",name); /* carve out file name */
	if (aplloae(rite->aplptr.aplchar,name,name+strlen(name))) {
		for (totree = savtree; totree->treenext != NULL;
			totree = totree->treenext); /* find bottom of stack */
		fromtree = treehdr; /* tree to copy from */
		treehdr = totree; /* setup to copy to trunk, i.e. global */
		cp += strlen(name); /* bump past file name in command buffer */
		for (tok = tokhdr = execpars(cp,cpend-cp);
			tok != NULL && aplerr == 0;
			tok = tok->token_queue.token_next_ptr)
			if (tok->token_code != OPERAND_TOKEN)
				aplerr = 58; /* syntax error */
			else /* copy one object */
				aplcpya(fromtree,tok->token_ptr.token_string,pcopy);
		if (tokhdr == NULL)
			aplcpyb(fromtree,fromtree->avlhdr,pcopy); /* copy all */
		treehdr = fromtree; /* restore for cleanup */
	}
	aplclean(); /* clean out loaded workspace */
	aplfile = savfile;
	fuzz = savfuzz;
	treehdr = savtree;
	savxorg = indxorg;
	execpop(&tokhdr); /* pop and free tokens on stack */
}
