/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* aplcopy APL2 V1.0.0 *************************************************
* Called by without, enclose, pick, disclose, first, squadix, assign,  *
* newderiv, grade2, and dtacopy.                                       *
* Copies the specified APL variable.  This routine is exceptional in   *
* that is doesn't free its argument if marked temporary.               *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb aplcopy(rite)
Aplcb rite;
{
	Aplcopy; Dtacopy; Getcb; Intcopy;
	extern int aplerr;
	Aplcb out,proto;

	if (aplerr || rite == NULL) return(NULL);
	out = getcb(NULL,rite->aplcount,rite->aplflags,rite->aplrank,NULL);
	if (aplerr) return(NULL);
	if (out->aplrank > 1) /* rank higher than vector? */
		intcopy(out->apldim,rite->apldim,out->aplrank,1);
	if (out->aplcount)
		dtacopy(out->aplptr.aplint, rite->aplptr.aplint,
			out->aplcount,1,out->aplflags & (APLMASK + APLAPL));
	else if (out->aplflags & APLAPL)
     	if (NULL != (proto = *(rite->aplptr.aplapl)))
     		*(out->aplptr.aplapl) = aplcopy(proto);
	return(out);
}
