/*Copyright (C) 1993, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* inverta.h APL2 V1.0.0 **********************************************
* Included in invert.  Variable i will contain the current row. Rows  *
* will contain the number of rows and columns in the square matrix    *
* pointed to by m.  This code will search from row i down to find the *
* row with the largest leftmost nonzero element; that row, if found,  *
* will be interchanged with row i.                                    *
**********************************************************************/
		k=-1;
		w=0.0;
		for (j=i;j<rows;j++) {
			x=*(m+j*rows+i); 
			/* x is leftmost nonzero element in row j */
			x=(0.0>x)?0.0-x:x; /* absolute value */
			if (x>w) {
				k=j; /* save row number */
				w=x; /* potential max value */
			}
		}
		if (k==-1) { /* matrix isn't invertible */
			free(z);
			return(NULL);
		}
		if (k!=i) {
			p=k*rows; /* common expression */
			for (j=i;j<rows;j++) {
				/* interchange rows to maximize precision */
				w=*(t=(m+n+j));
				*t=*(v=(m+p+j));
				*v=w;
			}
			for (j=0;j<rows;j++) {
				w=*(t=(z+n+j));
				*t=*(v=(z+p+j));
				*v=w;
			}
		}


