/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funstrud.h - APL2 V1.0.0 ********************************************
* These structures are used to describe all the builtin APL functions. *
* Funstrud is INCLUDEd by funstruc.h.                                  *
***********************************************************************/
#if !defined(FUNSTRUD_INCL)
#define FUNSTRUD_INCL
typedef struct codes {
     int funky_code; /* function code, e.g. QUOTE_DOT, DIVIDE, etc. */
     int funky_flags; /* SCALAR, etc. - see funcodes.h */
} Codes;
typedef struct identities {
     int iid; double did;
} Identities;
typedef struct scalar_dyadic_procs {
     void   (*ppint)(int*,int*,int*);
     void   (*ppdbl)(double*,double*,double*);
     void   (*ppmix)(double*,double*,int*);
     void   (*ppchr)(char*,char*,int*);
     void   (*ppcpx)(double*,double*,double*);
     void   (*ppmpx)(double*,double*,int*);
} Scalar_dyadic_procs;
typedef struct scalar_dyadic_funcs {
     int    (*epint)(int,int);
     double (*epdbl)(double,double);
     int    (*epmix)(double,double);
} Scalar_dyadic_funcs;
typedef struct scalar_dyadics {
     Identities identities;
     Scalar_dyadic_procs procs;
     Scalar_dyadic_funcs funcs;
} Scalar_dyadics;
typedef struct scalar_monadic_funcs {
     int    (*epint)(int);
     double (*epdbl)(double);
     int    (*epmix)(double);
} Scalar_monadic_funcs;
typedef struct scalar_monadic_procs {
     void   (*ppint)(int*,int*);
     void   (*ppdbl)(double*,double*);
     void   (*ppmix)(double*,int*);
     void   (*ppcpx)(double*,double*);
} Scalar_monadic_procs;
typedef struct scalar_monadics {
	Scalar_monadic_procs procs;
     Scalar_monadic_funcs funcs;
} Scalar_monadics;
typedef union mixed_monadics {
     Aplcb (*epmix)(Aplcb);
     Aplcb (*epmixa)(Aplcb, int); /* with axis */
     Aplcb (*epmixe)(Aplcb, Aplcb); /* with axes */
     Aplcb (*epmixf)(Aplcb, double, Aplcb); /* ravel */
     Aplcb (*epmixg)(Aplcb, int, Aplcb); /* selective specification */
} Mixed_monadics;
typedef union mixed_dyadics {
     Aplcb (*epdix)(Aplcb, Aplcb);
     Aplcb (*epdixa)(Aplcb, Aplcb, int); /* with axis */
     Aplcb (*epdixe)(Aplcb, Aplcb, Aplcb); /* with axes */
     Aplcb (*epdixf)(Aplcb, Aplcb, Aplcb, Aplcb); /* sel. spec. */
     Aplcb (*epdixg)(Aplcb, Aplcb, Aplcb, char *); /* pick w/selspec */
} Mixed_dyadics;
#endif
