/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funcodes.h - APL2 V1.0.0 ********************************************
* Structures defined in funstruc.h are initialized describing all of   *
* the builtin APL functions.  These codes are stored in the "codes"    *
* field of each structure to identify its type.                        *
***********************************************************************/
#if !defined(FUNCODES_INCL)
#define FUNCODES_INCL
#define MONADIC    1
#define DYADIC     2
#define SCALAR     4
#define MIXED      8
#define AXIS      16
#define EQUALITY  32 /* equal/not equal is a special case             */
#define DUAL      64 /* same function called for both monadic, dyadic */
#define DBL      128 /* double numeric type only, double axis value   */
#define FIRST    256 /* default axis is first dimension               */
#define LAST     512 /* default axis is last dimension                */
#define OPER    1024 /* operator                                      */
#define AXED    2048 /* axes, may be vector, dyadic                   */
#define AXEM    4096 /* axes, may be vector, monadic                  */
#define SESP    8192 /* selective specification function              */
#define AXES AXED+AXEM                       /* 2048 + 4096    = 6144 */
#define SCDO SCALAR+DYADIC                   /* 4 + 2          =    6 */
#define SCMD SCALAR+MONADIC+DYADIC           /* 4 + 1 + 2      =    7 */
#define MXMO MIXED+MONADIC                   /* 8 + 1          =    9 */
     /* mixed, monadic only (compute)                                 */
#define DYAE MIXED+DYADIC                    /* 8 + 2          =   10 */
     /* find                                                          */
#define MIXD MIXED+MONADIC+DYADIC            /* 8 + 1 + 2      =   11 */
#define UPAR MIXD+AXED                       /* 11 + 2048      = 2059 */
#define MSMD SCMD+MIXED                      /* 7 + 8          =   15 */
     /* monadic scalar, dyadic mixed, roll/deal not/without           */
#define MIXA MIXD+AXIS                       /* 11 + 16        =   27 */
#define EQNE SCDO+EQUALITY                   /* 6 + 32         =   38 */
#define SAME MIXED+MONADIC+DYADIC+DUAL       /* 8 + 1 + 2 + 64 =   75 */
#define DYDB MIXED+DYADIC+DBL                /* 8 + 2 + 128    =  138 */
     /* decode, encode                                                */
#define MIXC MIXA+DBL                        /* 27 + 128       =  155 */
     /* axis for laminate is double                                   */
#define MIXF MIXA+FIRST                      /* 27 + 256       =  283 */
#define MIXL MIXA+LAST                       /* 27 + 512       =  539 */
#define OPAX OPER+AXIS                       /* 1024 + 16      = 1040 */
     /* compress(slash) expand(slope)                                 */
#define OPAF OPAX+FIRST                      /* 1040 + 256     = 1296 */
     /* slash-bar/slope-bar                                           */
#define OPAL OPAX+LAST                       /* 1040 + 512     = 1552 */
     /* slash/slope                                                   */
#define DIXE DYAE+AXES                       /* 10 + 6144      = 6154 */
     /* drop2                                                         */
#define MIXE MIXD+AXES                       /* 11 + 6144      = 6155 */
	/* enclose, partition, ravel2                                    */
#define MIXG MIXD+AXEM                       /* 11 + 4096      = 4107 */
     /* disclose, pick                                                */
#define DIXS DIXE+SESP                       /* 6154 + 8192    =14346 */
     /* squadix                                                       */
#endif
