/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funcase.H - APL2 V1.0.0 *********************************************
* Included in funinit.c to select the proper structure describing a    *
* builtin APL function.                                                *
***********************************************************************/
#if !defined(FUNCASE_INCL)
#define FUNCASE_INCL
case QUOTE_DOT:     func=&x01; break; /* factorial, binomial */
case DIVIDE:        func=&x02; break; /* reciprocal, divide */
case AND:           func=&x03; break; /* NIL, and */
case STAR:          func=&x04; break; /* exponential, power */
case PLUS:          func=&x05; break; /* conjugate, add */
case COMMA:         func=&x06; break; /* ravel, catenate, laminate */
case LESS:          func=&x07; break; /* NIL, less */
case EQUAL:         func=&x08; break; /* NIL, equal */
case GREATER:       func=&x09; break; /* NIL, greater */
case QUERY:         func=&x10; break; /* roll, deal */
case LOG:           func=&x11; break; /* natural log, log */
case DELTA_STILE:   func=&x12; break; /* grade up, grade up */
case BASE:          func=&x13; break; /* NIL, decode */
case BASE_NULL:     func=&x14; break; /* execute */
case DOWNSTILE:     func=&x15; break; /* floor, minimum */
case EPSILON:       func=&x16; break; /* enlist, member */
case TOP_NULL:      func=&x17; break; /* format, format */
case IOTA:          func=&x18; break; /* interval, index of */
case NOT_GREATER:   func=&x19; break; /* NIL, not greater */
case DOMINO:        func=&x20; break; /* matrix inverse, divide */
case TOP:           func=&x21; break; /* NIL, encode */
case CIRCLE:        func=&x22; break; /* pi times, circular */
case NAND:          func=&x23; break; /* NIL, nand */
case RHO:           func=&x24; break; /* shape, reshape */
case UPSTILE:       func=&x25; break; /* ceiling, maximum */
case CIRCLE_SLOPE:  func=&x26; break; /* transpose, transpose */
case DOWN_ARROW:    func=&x27; break; /* NIL, drop */
case OR:            func=&x28; break; /* NIL, or */
case DEL_STILE:     func=&x29; break; /* grade down, grade down */
case TIMES:         func=&x30; break; /* direction, multiply */
case UP_ARROW:      func=&x31; break; /* first, take */
case NOT_LESS:      func=&x32; break; /* NIL, not less */
case NOT_EQUAL:     func=&x33; break; /* NIL, not equal */
case BAR:           func=&x34; break; /* negative, subtract */
case CIRCLE_STILE:  func=&x35; break; /* reverse, rotate */
case CIRCLE_BAR:    func=&x36; break; /* reverse, rotate */
case NOR:           func=&x37; break; /* NIL, nor */
case RIGHT_SHOE:    func=&x38; break; /* disclose, pick */
case LEFT_SHOE:     func=&x39; break; /* enclose, partition */
case STILE:         func=&x40; break; /* magnitude, residue */
case TILDE:         func=&x41; break; /* not, without */
case EQUAL_UNDERBAR:func=&x42; break; /* depth, match */
case EPSILON_UNDERBAR:func=&x43; break; /* NIL, find */
case SLASH:         func=&x44; break; /* compress, reduce */
case SLASH_BAR:     func=&x45; break; /* compress, reduce */
case SLOPE:         func=&x46; break; /* expand, scan */
case SLOPE_BAR:     func=&x47; break; /* expand, scan */
case DIERESIS:      func=&x48; break; /* each */
case DOT:           func=&x49; break; /* inner/outer product */
case APL_NULL:      func=&x50; break; /* outer product (jot) */
case SQUAD:         func=&x51; break; /* index */
case QUAD_EA:       func=&x52; break; /* execute alternate */
case LOGAMMA:       func=&x53; break; /* logamma */
#endif
