/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* encodei.h APL2 V1.0.0 ***********************************************
* Included in encodeb and encodec to do the encode.                    *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void EP(left,rite,out,ldata,rdata,odata)
struct aplcb *left,*rite,*out;
TYPE *ldata,*rdata,*odata;
{
     int i,j,k,m,
          laxicnt,lbotcnt,ltopcnt,
          oaxicnt,obotcnt,otopcnt;
     TYPE holdrite,*ip,*jp,*kp,*leftbase,MOD(),*outbase,rad,wrk;

     i = axispre(left,1,&laxicnt,&lbotcnt,&ltopcnt);
     i = axispre(out ,1,&oaxicnt,&obotcnt,&otopcnt);
     m = oaxicnt*obotcnt;
     for (i=0; i < rite->aplcount; i++) { /* once per item in rite */
          holdrite = *rdata++; /* rite item processed lbotcnt times */
          outbase = odata++; /* next output base point */
          leftbase = ldata; /* start of origin of left */
          for (j=0; j < lbotcnt; j++) {
               kp = (jp = outbase + j*rite->aplcount + m);
               for (k=0; k < oaxicnt; k++)
                    *(kp -= obotcnt) = ZERO;
               ip = leftbase++ + laxicnt*lbotcnt;
               wrk = holdrite; /* rite item currently being processed */
               for (k=0; k < laxicnt; k++) {
                    *(jp -= obotcnt) = MOD((rad=*(ip -= lbotcnt)),wrk);
                    if (rad == ZERO)
                         break;
                    wrk = (wrk - *jp) / rad;
               }
          }
     }
}
