/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* avltsub2.h APL2 V1.0.0 **********************************************
* Included in avltree.c.                                               *
* Phase 2:  Insert and rebalance.  Newnode is not in tree, and may be  *
* inserted as appropriate child of q.                                  *
***********************************************************************/

	if (strcmp(newnode->avlname,q->avlname) < 0)
		q->left_child = newnode;
	else
		q->rite_child = newnode;

	/* Adjust balance factors of nodes on path from a to q.  Note that
	by the definition of a, all nodes on this path must have balance
	factors of 0 and so will change to +-1.  d=+1 implies newnode is
	inserted in left subtree of a.  d=-1 implies newnode is inserted in
	right subtree of a. */

	d = isign(strcmp(a->avlname,newnode->avlname));
	if (d < 0) p = a->rite_child;
	else       p = a->left_child;
	b = p; /* save p */
	while (p != newnode) {
		p->avlbf = isign(strcmp(p->avlname,newnode->avlname));
		if (p->avlbf < 0) p = p->rite_child;
		else              p = p->left_child;
	}
	if (0 == a->avlbf) { /* tree is still balanced */
		a->avlbf = d;
		return(NULL);
	}
	if (0 == a->avlbf+d) { /* tree is balanced */
		a->avlbf = 0;
		return(NULL);
	}
