/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* avltsub1.h APL2 V1.0.0 **********************************************
* Included in avltree.c.                                               *
* Phase 1: Locate insertion point for newnode.  Variable a keeps track *
* track of the most recent node with balance factor +-1, and f is the  *
* parent of a.  Variable q follows p through the tree.                 *
***********************************************************************/

	f = q = NULL;
	a = p = *parmhdr;
	while (p != NULL) { /* search for insertion point */
		if (p->avlbf) {
			a = p; /* most recent node with bf +- 1 */
			f = q; /* parent of a */
		}
		q = p; /* parent of next p */
		switch (isign(strcmp(newnode->avlname,p->avlname))) {
			case -1: /* newnode->avlname < p->avlname */
				p = q->left_child;
				break;
			case  0: /* error - newnode is in tree already */
				return(p); /* not OK */
				break;
			case +1: /* newnode->avlname > p->avlname */
				p = q->rite_child;
				break;
		}
	}
