/* aplchdef.h APL2 V1.0.0 - copyright 1993 Thomas Glen Smith ***********
* Defines the codes used to indicate APL characters.  Changes to       *
* aplchdef.h must be synchronized with changes to aplchar.h            *
* ALPHAONE and ALPHATWO give the first an last codes for alphabetic    *
* characters, which must all be contiguously numbered.                 *
* ALPHABET is a generic code which may be used to represent any        *
* alphabetic character.                                                *
* DIGIT is a generic code which may be used to represent any digit.    *
***********************************************************************/
#if !defined(APLCHDEF_INCL)
#define APLCHDEF_INCL
#define APLMXLN 2
#define ALPHAONE 79
#define ALPHATWO 130
#define DIGIT -3
#define ALPHABET -2
#define UNKNOWN -1
#define SPACE  0
#define QUOTE_DOT  1
#define CAP_NULL  2
#define LEFT_ARROW  3
#define RIGHT_ARROW  4
#define DIVIDE  5
#define AND  6
#define QUOTE  7
#define LEFT_PAREN  8
#define RIGHT_PAREN  9
#define STAR 10
#define PLUS 11
#define COMMA 12
#define OVERBAR 13
#define DOT 14
#define SLASH 15
#define APL_0 16
#define APL_1 17
#define APL_2 18
#define APL_3 19
#define APL_4 20
#define APL_5 21
#define APL_6 22
#define APL_7 23
#define APL_8 24
#define APL_9 25
#define COLON 26
#define SEMICOLON 27
#define LESS 28
#define EQUAL 29
#define GREATER 30
#define QUERY 31
#define LOG 32
#define DELTA_STILE 33
#define BASE 34
#define BASE_NULL 35
#define DOWNSTILE 36
#define EPSILON 37
#define TOP_NULL 38
#define DEL 39
#define DELTA 40
#define IOTA 41
#define APL_NULL 42
#define NOT_GREATER 43
#define QUAD 44
#define DOMINO 45
#define TOP 46
#define CIRCLE 47
#define NAND 48
#define QUOTE_QUAD 49
#define RHO 50
#define UPSTILE 51
#define CIRCLE_SLOPE 52
#define DOWN_ARROW 53
#define OR 54
#define DEL_STILE 55
#define TIMES 56
#define UP_ARROW 57
#define NOT_LESS 58
#define LEFT_BRACKET 59
#define SLOPE 60
#define RIGHT_BRACKET 61
#define NOT_EQUAL 62
#define BAR 63
#define SLASH_BAR 64
#define DIERESIS 65
#define ALPHA 66
#define CAP 67
#define DEL_TILDE 68
#define I_BEAM 69
#define CIRCLE_STILE 70
#define CIRCLE_BAR 71
#define CUP 72
#define NOR 73
#define OMEGA 74
#define RIGHT_SHOE 75
#define LEFT_SHOE 76
#define SLOPE_BAR 77
#define UNDERBAR 78
#define APL_A_UNDERSCORE 79
#define APL_B_UNDERSCORE 80
#define APL_C_UNDERSCORE 81
#define APL_D_UNDERSCORE 82
#define APL_E_UNDERSCORE 83
#define APL_F_UNDERSCORE 84
#define APL_G_UNDERSCORE 85
#define APL_H_UNDERSCORE 86
#define APL_I_UNDERSCORE 87
#define APL_J_UNDERSCORE 88
#define APL_K_UNDERSCORE 89
#define APL_L_UNDERSCORE 90
#define APL_M_UNDERSCORE 91
#define APL_N_UNDERSCORE 92
#define APL_O_UNDERSCORE 93
#define APL_P_UNDERSCORE 94
#define APL_Q_UNDERSCORE 95
#define APL_R_UNDERSCORE 96
#define APL_S_UNDERSCORE 97
#define APL_T_UNDERSCORE 98
#define APL_U_UNDERSCORE 99
#define APL_V_UNDERSCORE 100
#define APL_W_UNDERSCORE 101
#define APL_X_UNDERSCORE 102
#define APL_Y_UNDERSCORE 103
#define APL_Z_UNDERSCORE 104
#define APL_A 105
#define APL_B 106
#define APL_C 107
#define APL_D 108
#define APL_E 109
#define APL_F 110
#define APL_G 111
#define APL_H 112
#define APL_I 113
#define APL_J 114
#define APL_K 115
#define APL_L 116
#define APL_M 117
#define APL_N 118
#define APL_O 119
#define APL_P 120
#define APL_Q 121
#define APL_R 122
#define APL_S 123
#define APL_T 124
#define APL_U 125
#define APL_V 126
#define APL_W 127
#define APL_X 128
#define APL_Y 129
#define APL_Z 130
#define STILE 131
#define TILDE 132
#define EQUAL_UNDERBAR 133
#define EPSILON_UNDERBAR 134
#define SQUAD 135
#define LOGAMMA 136
#endif
