/* aplchax.h APL2 V1.0.0 - Copyright 1993 Thomas Glen Smith ************
* Contains aplchax, an int array containing indices to aplchar.        *
* Accessing aplchar via the indices in aplchax gives you the APL       *
* character set in collated order.                                     *
***********************************************************************/
#if !defined(APLCHAX_INCL)
#define APLCHAX_INCL
     int aplchax[APLCHNO] = {
     0,   /* " "  '\x2000' space - must be single character           */
     1,   /* "!"  '\x2100' quote dot (binomial, factorial             */
     2,   /* "\"" '\x2200' cap null (comment                          */
     3,   /* "#"  '\x2300' left arrow (assignment                     */
     4,   /* "$"  '\x2400' right arrow (branch)                       */
     5,   /* "%"  '\x2500' divide (divide)                            */
     6,   /* "&"  '\x2600' and (and)                                  */
     7,   /* "'"  '\x2700' quote (character constants) single characte*/
     8,   /* "("  '\x2800' left paren (order of execution)            */
     9,   /* ")"  '\x2900' right paren (order of execution)           */
     10,  /* "*"  '\x2a00' star (exponential, power)                  */
     11,  /* "+"  '\x2b00' plus (plus, conjugate)                     */
     12,  /* ","  '\x2c00' comma (catenate, laminate, ravel)          */
     13,  /* "-"  '\x2d00' overbar (negative numbers)                 */
     14,  /* "."  '\x2e00' dot (inner, outer product) m/b single char */
     15,  /* "/"  '\x2f00' slash (compress, reduction)                */
     16,  /* "0"  '\x3000' digit 0 digits must be contiguous, and must*/
     17,  /* "1"  '\x3100' digit 1 be single characters.              */
     18,  /* "2"  '\x3200' digit 2                                    */
     19,  /* "3"  '\x3300' digit 3                                    */
     20,  /* "4"  '\x3400' digit 4                                    */
     21,  /* "5"  '\x3500' digit 5                                    */
     22,  /* "6"  '\x3600' digit 6                                    */
     23,  /* "7"  '\x3700' digit 7                                    */
     24,  /* "8"  '\x3800' digit 8                                    */
     25,  /* "9"  '\x3900' digit 9                                    */
     26,  /* ":"  '\x3a00' colon (labels)                             */
     27,  /* ";"  '\x3b00' semicolon (function header, indexing)      */
     28,  /* "<"  '\x3c00' less (less than)                           */
     29,  /* "="  '\x3d00' equal (equal)                              */
     30,  /* ">"  '\x3e00' greater (greater than)                     */
     31,  /* "?"  '\x3f00' query (deal, roll)                         */
     32,  /* "@"  '\x4000' log (general and natural logarithm)        */
     33,  /* "A"  '\x4100' delta stile (grade up)                     */
     34,  /* "B"  '\x4200' base (decode)                              */
     35,  /* "C"  '\x4300' base null (execute)                        */
     36,  /* "D"  '\x4400' downstile (floor, minimum)                 */
     37,  /* "E"  '\x4500' epsilon (membership)                       */
     38,  /* "F"  '\x4600' top null (format)                          */
     39,  /* "G"  '\x4700' del                                        */
     40,  /* "H"  '\x4800' delta                                      */
     41,  /* "I"  '\x4900' iota (index generator, index of)           */
     42,  /* "J"  '\x4a00' null (inner product, outer product)        */
     43,  /* "K"  '\x4b00' not greater (not greater)                  */
     44,  /* "L"  '\x4c00' quad (evaluated input)        single charac*/
     45,  /* "M"  '\x4d00' domino (matrix divide and inverse)         */
     46,  /* "N"  '\x4e00' top (encode)                               */
     47,  /* "O"  '\x4f00' circle (cirular, hyperbolic, pythagorus, pi*/
     48,  /* "P"  '\x5000' nand (nand)                                */
     49,  /* "Q"  '\x5100' quote-quad (character input)               */
     50,  /* "R"  '\x5200' rho (reshape, shape)                       */
     51,  /* "S"  '\x5300' upstile (ceiling, maximum)                 */
     52,  /* "T"  '\x5400' circle slope (transpose)                   */
     53,  /* "U"  '\x5500' down arrow (drop)                          */
     54,  /* "V"  '\x5600' or (or)                                    */
     55,  /* "W"  '\x5700' del stile (grade down)                     */
     56,  /* "X"  '\x5800' times (signum, times)                      */
     57,  /* "Y"  '\x5900' up arrow (take)                            */
     58,  /* "Z"  '\x5a00' not less (not less)                        */
     59,  /* "["  '\x5b00' left bracket (axis, indexing)              */
     60,  /* "\\" '\x5c00' slope (expand, scan)                       */
     61,  /* "]"  '\x5d00' right bracket (axis, indexing)             */
     62,  /* "^=" '\x5e3d00' not equal (exclusize or)                 */
     63,  /* "_"  '\x5f00' bar (minus, negative)                      */
     64,  /* "`/" '\x602f00' slash bar (compress, reduction)          */
     65,  /* "`1" '\x603100' dieresis                                 */
    136,  /* "`2" '\x603200' logamma                                  */
    133,  /* "`=" '\x603d00' equal underbar (depth)                   */
     66,  /* "`A" '\x604100' alpha                                    */
     67,  /* "`C" '\x604300' cap                                      */
    134,  /* "`E" '\x604500' epsilon underbar (find)                  */
     68,  /* "`G" '\x604700' del tilde                                */
     69,  /* "`I" '\x604900' I-beam                                   */
     70,  /* "`O" '\x604f00' circle stile (reverse, rotate)           */
    135,  /* "`Q" '\x605100' squad (index)                            */
     71,  /* "`R" '\x605200' circle bar (reverse)                     */
     72,  /* "`U" '\x605500' cup                                      */
     73,  /* "`V" '\x605600' nor (nor)                                */
     74,  /* "`W" '\x605700' omega                                    */
     75,  /* "`X" '\x605800' right shoe                               */
     76,  /* "`Z" '\x605a00' left shoe                                */
     77,  /* "`\\"'\x605c00' slope bar (expand, scan)                 */
     78,  /* "`_" '\x605f00' underbar                                 */
     79,  /* "`a" '\x606100' Alphabetic A underscored                 */
     80,  /* "`b" '\x606200' Alphabetic B underscored                 */
     81,  /* "`c" '\x606300' Alphabetic C underscored                 */
     82,  /* "`d" '\x606400' Alphabetic D underscored                 */
     83,  /* "`e" '\x606500' Alphabetic E underscored                 */
     84,  /* "`f" '\x606600' Alphabetic F underscored                 */
     85,  /* "`g" '\x606700' Alphabetic G underscored                 */
     86,  /* "`h" '\x606800' Alphabetic H underscored                 */
     87,  /* "`i" '\x606900' Alphabetic I underscored                 */
     88,  /* "`j" '\x606a00' Alphabetic J underscored                 */
     89,  /* "`k" '\x606b00' Alphabetic K underscored                 */
     90,  /* "`l" '\x606c00' Alphabetic L underscored                 */
     91,  /* "`m" '\x606d00' Alphabetic M underscored                 */
     92,  /* "`n" '\x606e00' Alphabetic N underscored                 */
     93,  /* "`o" '\x606f00' Alphabetic O underscored                 */
     94,  /* "`p" '\x607000' Alphabetic P underscored                 */
     95,  /* "`q" '\x607100' Alphabetic Q underscored                 */
     96,  /* "`r" '\x607200' Alphabetic R underscored                 */
     97,  /* "`s" '\x607300' Alphabetic S underscored                 */
     98,  /* "`t" '\x607400' Alphabetic T underscored                 */
     99,  /* "`u" '\x607500' Alphabetic U underscored                 */
     100, /* "`v" '\x607600' Alphabetic V underscored                 */
     101, /* "`w" '\x607700' Alphabetic W underscored                 */
     102, /* "`x" '\x607800' Alphabetic X underscored                 */
     103, /* "`y" '\x607900' Alphabetic Y underscored                 */
     104, /* "`z" '\x607a00' Alphabetic Z underscored                 */
     105, /* "a"  '\x6100' Alphabetic A   single character            */
     106, /* "b"  '\x6200' Alphabetic B   single character            */
     107, /* "c"  '\x6300' Alphabetic C single character              */
     108, /* "d"  '\x6400' Alphabetic D   single character            */
     109, /* "e"  '\x6500' Alphabetic E   single character            */
     110, /* "f"  '\x6600' Alphabetic F   single character            */
     111, /* "g"  '\x6700' Alphabetic G   single character            */
     112, /* "h"  '\x6800' Alphabetic H   single character            */
     113, /* "i"  '\x6900' Alphabetic I   single character            */
     114, /* "j"  '\x6a00' Alphabetic J   single character            */
     115, /* "k"  '\x6b00' Alphabetic K   single character            */
     116, /* "l"  '\x6c00' Alphabetic L   single character            */
     117, /* "m"  '\x6d00' Alphabetic M   single character            */
     118, /* "n"  '\x6e00' Alphabetic N   single character            */
     119, /* "o"  '\x6f00' Alphabetic O   single character            */
     120, /* "p"  '\x7000' Alphabetic P   single character            */
     121, /* "q"  '\x7100' Alphabetic Q   single character            */
     122, /* "r"  '\x7200' Alphabetic R   single character            */
     123, /* "s"  '\x7300' Alphabetic S   single character            */
     124, /* "t"  '\x7400' Alphabetic T   single character            */
     125, /* "u"  '\x7500' Alphabetic U   single character            */
     126, /* "v"  '\x7600' Alphabetic V   single character            */
     127, /* "w"  '\x7700' Alphabetic W   single character            */
     128, /* "x"  '\x7800' Alphabetic X   single character            */
     129, /* "y"  '\x7900' Alphabetic Y   single character            */
     130, /* "z"  '\x7a00' Alphabetic Z   single character            */
     131, /* "|"  '\x7c00' stile (magnitude, residue)                 */
     132  /* "~"  '\x7e00' tilde (not)                                */
     };
#endif
