/* aplchar.h APL2 V1.0.0 - Copyright 1993 Thomas Glen Smith ************
* Contains three global variables:                                     *
*  1) aplchar - A char array containing representations of the APL     *
*     character set, allowing a standard PC keyboard to be used for    *
*     entering APL statements.                                         *
*  2) aplchno - An int containing the number of elements in aplchar.   *
*  3) aplmxln - An int giving the maximum length element in aplchar.   *
* Aplchar.h can be replaced or changed with these provisos:            *
*  1) Each element must be left-to-right unique, i.e. it would not     *
*     work to have one element be "A" and another "AB".                *
*  2) Any change to aplchar.h must be reflected in aplchdef.h.         *
*  3) Some elements must be a single character, as indicated in the    *
*     comments below.                                                  *
* See also aplchax.h.                                                  *
***********************************************************************/
#if !defined(APLCHAR_INCL)
#define APLCHAR_INCL
     #define APLCHNO 137
     int aplchno = APLCHNO;
     int aplmxln = 2; /* maximum element length */
     char *aplchar[APLCHNO] = {
     " ",      /*  0 '\x2000' space - must be single character        */
     "!",      /*  1 '\x2100' quote dot (binomial, factorial          */
     "\"",     /*  2 '\x2200' cap null (comment                       */
     "#",      /*  3 '\x2300' left arrow (assignment                  */
     "$",      /*  4 '\x2400' right arrow (branch)                    */
     "%",      /*  5 '\x2500' divide (divide)                         */
     "&",      /*  6 '\x2600' and (and)                               */
     "'",      /*  7 '\x2700' quote (character constants) single char */
     "(",      /*  8 '\x2800' left paren (order of execution)         */
     ")",      /*  9 '\x2900' right paren (order of execution)        */
     "*",      /* 10 '\x2a00' star (exponential, power)               */
     "+",      /* 11 '\x2b00' plus (plus, conjugate)                  */
     ",",      /* 12 '\x2c00' comma (catenate, laminate, ravel)       */
     "-",      /* 13 '\x2d00' overbar (negative numbers)              */
     ".",      /* 14 '\x2e00' dot (inner, outer product) m/b single ch*/
     "/",      /* 15 '\x2f00' slash (compress, reduction)             */
     "0",      /* 16 '\x3000' digit 0 digits must be contiguous, and  */
     "1",      /* 17 '\x3100' digit 1 must be single characters.      */
     "2",      /* 18 '\x3200' digit 2                                 */
     "3",      /* 19 '\x3300' digit 3                                 */
     "4",      /* 20 '\x3400' digit 4                                 */
     "5",      /* 21 '\x3500' digit 5                                 */
     "6",      /* 22 '\x3600' digit 6                                 */
     "7",      /* 23 '\x3700' digit 7                                 */
     "8",      /* 24 '\x3800' digit 8                                 */
     "9",      /* 25 '\x3900' digit 9                                 */
     ":",      /* 26 '\x3a00' colon (labels)                          */
     ";",      /* 27 '\x3b00' semicolon (function header, indexing)   */
     "<",      /* 28 '\x3c00' less (less than)                        */
     "=",      /* 29 '\x3d00' equal (equal)                           */
     ">",      /* 30 '\x3e00' greater (greater than)                  */
     "?",      /* 31 '\x3f00' query (deal, roll)                      */
     "@",      /* 32 '\x4000' log (general and natural logarithm)     */
     "A",      /* 33 '\x4100' delta stile (grade up)                  */
     "B",      /* 34 '\x4200' base (decode)                           */
     "C",      /* 35 '\x4300' base null (execute)                     */
     "D",      /* 36 '\x4400' downstile (floor, minimum)              */
     "E",      /* 37 '\x4500' epsilon (membership)                    */
     "F",      /* 38 '\x4600' top null (format)                       */
     "G",      /* 39 '\x4700' del                                     */
     "H",      /* 40 '\x4800' delta                                   */
     "I",      /* 41 '\x4900' iota (index generator, index of)        */
     "J",      /* 42 '\x4a00' null (inner product, outer product)     */
     "K",      /* 43 '\x4b00' not greater (not greater)               */
     "L",      /* 44 '\x4c00' quad (evaluated input)      single chara*/
     "M",      /* 45 '\x4d00' domino (matrix divide and inverse)      */
     "N",      /* 46 '\x4e00' top (encode)                            */
     "O",      /* 47 '\x4f00' circle (cirular, hyperbolic, pythagorus,*/
     "P",      /* 48 '\x5000' nand (nand)                             */
     "Q",      /* 49 '\x5100' quote-quad (character input)            */
     "R",      /* 50 '\x5200' rho (reshape, shape)                    */
     "S",      /* 51 '\x5300' upstile (ceiling, maximum)              */
     "T",      /* 52 '\x5400' circle slope (transpose)                */
     "U",      /* 53 '\x5500' down arrow (drop)                       */
     "V",      /* 54 '\x5600' or (or)                                 */
     "W",      /* 55 '\x5700' del stile (grade down)                  */
     "X",      /* 56 '\x5800' times (signum, times)                   */
     "Y",      /* 57 '\x5900' up arrow (take)                         */
     "Z",      /* 58 '\x5a00' not less (not less)                     */
     "[",      /* 59 '\x5b00' left bracket (axis, indexing)           */
     "\\",     /* 60 '\x5c00' slope (expand, scan)                    */
     "]",      /* 61 '\x5d00' right bracket (axis, indexing)          */
     "^=",     /* 62 '\x5e3d00' not equal (exclusize or)              */
     "_",      /* 63 '\x5f00' bar (minus, negative)                   */
     "`/",     /* 64 '\x602f00' slash bar (compress, reduction)       */
     "`1",     /* 65 '\x603100' dieresis                              */
     "`A",     /* 66 '\x604100' alpha                                 */
     "`C",     /* 67 '\x604300' cap                                   */
     "`G",     /* 68 '\x604700' del tilde                             */
     "`I",     /* 69 '\x604900' I-beam                                */
     "`O",     /* 70 '\x604f00' circle stile (reverse, rotate)        */
     "`R",     /* 71 '\x605200' circle bar (reverse)                  */
     "`U",     /* 72 '\x605500' cup                                   */
     "`V",     /* 73 '\x605600' nor (nor)                             */
     "`W",     /* 74 '\x605700' omega                                 */
     "`X",     /* 75 '\x605800' right shoe                            */
     "`Z",     /* 76 '\x605a00' left shoe                             */
     "`\\",    /* 77 '\x605c00' slope bar (expand, scan)              */
     "`_",     /* 78 '\x605f00' underbar                              */
               /* Alphabetics should be contiguous                    */
     "`a",     /* 79 '\x606100' Alphabetic A underscored              */
     "`b",     /* 80 '\x606200' Alphabetic B underscored              */
     "`c",     /* 81 '\x606300' Alphabetic C underscored              */
     "`d",     /* 82 '\x606400' Alphabetic D underscored              */
     "`e",     /* 83 '\x606500' Alphabetic E underscored              */
     "`f",     /* 84 '\x606600' Alphabetic F underscored              */
     "`g",     /* 85 '\x606700' Alphabetic G underscored              */
     "`h",     /* 86 '\x606800' Alphabetic H underscored              */
     "`i",     /* 87 '\x606900' Alphabetic I underscored              */
     "`j",     /* 88 '\x606a00' Alphabetic J underscored              */
     "`k",     /* 89 '\x606b00' Alphabetic K underscored              */
     "`l",     /* 90 '\x606c00' Alphabetic L underscored              */
     "`m",     /* 91 '\x606d00' Alphabetic M underscored              */
     "`n",     /* 92 '\x606e00' Alphabetic N underscored              */
     "`o",     /* 93 '\x606f00' Alphabetic O underscored              */
     "`p",     /* 94 '\x607000' Alphabetic P underscored              */
     "`q",     /* 95 '\x607100' Alphabetic Q underscored              */
     "`r",     /* 96 '\x607200' Alphabetic R underscored              */
     "`s",     /* 97 '\x607300' Alphabetic S underscored              */
     "`t",     /* 98 '\x607400' Alphabetic T underscored              */
     "`u",     /* 99 '\x607500' Alphabetic U underscored              */
     "`v",     /*100 '\x607600'  Alphabetic V underscored             */
     "`w",     /*101 '\x607700'  Alphabetic W underscored             */
     "`x",     /*102 '\x607800'  Alphabetic X underscored             */
     "`y",     /*103 '\x607900'  Alphabetic Y underscored             */
     "`z",     /*104 '\x607a00'  Alphabetic Z underscored             */
     "a",      /*105 '\x6100'  alphabetic A single character          */
     "b",      /*106 '\x6200'  alphabetic B single character          */
     "c",      /*107 '\x6300'  alphabetic C single character          */
     "d",      /*108 '\x6400'  alphabetic D single character          */
     "e",      /*109 '\x6500'  alphabetic E single character          */
     "f",      /*110 '\x6600'  alphabetic F single character          */
     "g",      /*111 '\x6700'  alphabetic G single character          */
     "h",      /*112 '\x6800'  alphabetic H single character          */
     "i",      /*113 '\x6900'  alphabetic I single character          */
     "j",      /*114 '\x6a00'  alphabetic J single character          */
     "k",      /*115 '\x6b00'  alphabetic K single character          */
     "l",      /*116 '\x6c00'  alphabetic L single character          */
     "m",      /*117 '\x6d00'  alphabetic M single character          */
     "n",      /*118 '\x6e00'  alphabetic N single character          */
     "o",      /*119 '\x6f00'  alphabetic O single character          */
     "p",      /*120 '\x7000'  alphabetic P single character          */
     "q",      /*121 '\x7100'  alphabetic Q single character          */
     "r",      /*122 '\x7200'  alphabetic R single character          */
     "s",      /*123 '\x7300'  alphabetic S single character          */
     "t",      /*124 '\x7400'  alphabetic T single character          */
     "u",      /*125 '\x7500'  alphabetic U single character          */
     "v",      /*126 '\x7600'  alphabetic V single character          */
     "w",      /*127 '\x7700'  alphabetic W single character          */
     "x",      /*128 '\x7800'  alphabetic X single character          */
     "y",      /*129 '\x7900'  alphabetic Y single character          */
     "z",      /*130 '\x7a00'  alphabetic Z single character          */
     "|",      /*131 '\x7c00'  stile (magnitude, residue)             */
     "~",      /*132 '\x7e00'  tilde (not)                            */
     "`=",     /*133 '\x603d00'  equal underbar (depth)               */
     "`E",     /*134 '\x604500'  epsilon underbar (find)              */
     "`Q",     /*135 '\x605100'  squad (index)                        */
     "`2"      /*136 '\x603200'  logamma                              */
     };
#endif
