#include <qlib.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>
#include <stdlib.h>

//#define log2 log10

void err(int a) {
  if (errno) {
    fprintf(stderr,"%i -",a);
    perror("MATHTEST");
  }
  errno=0;
}

void main(void)
{
    double result, source, power;

    errno=0;
    source=0.0;
    power=0.0;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(1);

    source=3.321;
    power=5.4522;
    result=pow(source, power);
    printf("%13f powered to %13f is %13e\n", source, power, result);
    err(2);

    source=2623.321;
    power=245.4522;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(3);

    source=-430.321;
    power=45.4522;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(4);

    source=0;
    power=45.4522;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(5);

    source=-430.321;
    power=-45.4522;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(6);

    source=430.321;
    power=0;
    result=pow(source, power);
    printf("%13f powered to %13f is %13f\n", source, power, result);
    err(7);

    source=22.454355;
    result=sqrt(source);
    printf("the square root of %13f is %13f\n", source, result);
    err(8);

    source=-22.454355;
    result=sqrt(source);
    printf("the square root of %13f is %13f\n", source, result);
    err(9);

    source=0;
    result=sqrt(source);
    printf("the square root of %13f is %13f\n", source, result);
    err(10);

    source=22.454355;
    result=log2(source);
    printf("the log2  of %13f is %13f\n", source, result);
    err(11);

    source=-22.454355;
    result=log2(source);
    printf("the log2  of %13f is %13f\n", source, result);
    err(12);

    source=0;
    result=log2(source);
    printf("the log2  of %13f is %13f\n", source, result);
    err(13);

    source=22.454355;
    result=log10(source);
    printf("the log10 of %13f is %13f\n", source, result);
    err(14);

    source=-22.454355;
    result=log10(source);
    printf("the log10 of %13f is %13f\n", source, result);
    err(15);

    source=0;
    result=log10(source);
    printf("the log10 of %13f is %13f\n", source, result);
    err(16);

    source=22.454355;
    result=log(source);
    printf("the log   of %13f is %13f\n", source, result);
    err(17);

    source=-22.454355;
    result=log(source);
    printf("the log   of %13f is %13f\n", source, result);
    err(18);

    source=0;
    result=log(source);
    printf("the log   of %13f is %13f\n", source, result);
    err(19);

    source=2555.355;
    result=exp(source);
    printf("the exp   of %13f is %13f\n", source, result);
    err(20);

    source=2.454355;
    result=exp(source);
    printf("the exp   of %13f is %13f\n", source, result);
    err(21);

    source=-2.454355;
    result=exp(source);
    printf("the exp   of %13f is %13f\n", source, result);
    err(22);

    source=0;
    result=exp(source);
    printf("the exp   of %13f is %13f\n", source, result);
    err(23);

}
