;error code strings (errno)

include qlib.inc
include stdio.inc

.data
externdef errno:word
externdef sys_nerr:dword
externdef sys_errlist:byte

sys_nerr dd ((sys_end - sys_start) /4)

sys_start equ $
sys_errlist label byte
dd offset EZERO
dd offset EINVFNC
dd offset ENOENT  ;  2      ; No such file or directory
dd offset ENOFILE
dd offset EMFILE  ;  4      ; Too many open files      
dd offset EACCES  ;  5      ; Permission denied        
dd offset EBADF   ;  6      ; Bad file number          
dd offset ENOPATH
dd offset ENOMEM  ;  8      ; Not enough core          
dd offset ECONTR 
dd offset EINVENV
dd offset EINVFMT
dd offset EINVACC
dd offset EINVDAT
dd offset EFAULT  ; 14      ; Unknown error            
dd offset EINVDRV
dd offset ECURDIR
dd offset ENOTSAM
dd offset ENMFILE

dd offset EINVAL  ; 19      ; Invalid argument         
dd offset E2BIG   ; 20      ; Arg list too long        
dd offset ENOEXEC ; 21      ; Exec format error        
dd offset EXDEV   ; 22      ; Cross-device link        
dd offset ENFILE  ; 23      ; Too many open files      
dd offset ECHILD  ; 24      ; No child process         
dd offset ENOTTY  ; 25      ; UNIX - not MSDOS         
dd offset ETXTBSY ; 26      ; UNIX - not MSDOS         
dd offset EFBIG   ; 27      ; UNIX - not MSDOS         
dd offset ENOSPC  ; 28      ; No space left on device  
dd offset ESPIPE  ; 29      ; Illegal seek             
dd offset EROFS   ; 30      ; Read-only file system    
dd offset EMLINK  ; 31      ; UNIX - not MSDOS         
dd offset EPIPE   ; 32      ; Broken pipe              
dd offset EDOM    ; 33      ; Math argument            
dd offset ERANGE  ; 34      ; Result too large         
dd offset EEXIST  ; 35      ; File already exists      
dd offset EDEADLOCK ; 36    ; Locking violation        
dd offset EPERM   ; 37      ; Operation not permitted  
dd offset ESRCH   ; 38      ; UNIX - not MSDOS         
dd offset EINTR   ; 39      ; Interrupted function call 
dd offset EIO     ; 40      ; Input/output error       
dd offset ENXIO   ; 41      ; No such device or address 
dd offset EAGAIN  ; 42      ; Resource temporarily unavailable 
dd offset ENOTBLK ; 43      ; UNIX - not MSDOS         
dd offset EBUSY   ; 44      ; Resource busy            
dd offset ENOTDIR ; 45      ; UNIX - not MSDOS         
dd offset EISDIR  ; 46      ; UNIX - not MSDOS         
dd offset EUCLEAN ; 47      ; UNIX - not MSDOS         






EZERO   db 'No Error',0
EINVFNC db 'Invalid function number',0
ENOFILE db 'File not found',0
ENOPATH db 'Path not found',0
ECONTR  db 'Memory blocks destroyed',0
EINVMEM db 'Invalid memory block address',0
EINVENV db 'Invalid environment',0
EINVFMT db 'Invalid format',0
EINVACC db 'Invalid access code',0
EINVDAT db 'Invalid data',0
EINVDRV db 'Invalid drive specified',0
ECURDIR db 'Attempt to remove CurDir',0
ENOTSAM db 'Not same device',0
ENMFILE db 'No more files',0

ENOENT  db 'No such file or directory',0
EMFILE  db 'Too many open files',0
EACCES  db 'Permission denied',0
EBADF   db 'Bad file number',0
ENOMEM  db 'Not enough core',0
EFAULT  db 'Unknown error',0
EINVAL  db 'Invalid argument',0
E2BIG   db 'Arg list too long',0
ENOEXEC db 'Exec format error',0
EXDEV   db 'Cross-device link',0
ENFILE  db 'Too many open files',0
ECHILD  db 'No child process',0
ENOTTY  db 'UNIX - not MSDOS',0
ETXTBSY db 'UNIX - not MSDOS',0
EFBIG   db 'UNIX - not MSDOS',0
ENOSPC  db 'No space left on device',0
ESPIPE  db 'Illegal seek',0
EROFS   db 'Read-only file system',0
EMLINK  db 'UNIX - not MSDOS',0
EPIPE   db 'Broken pipe',0
EDOM    db 'Math argument',0
ERANGE  db 'Result too large',0
EEXIST  db 'File already exists',0
EDEADLOCK db 'Locking violation',0
EPERM   db 'Operation not permitted',0
ESRCH   db 'UNIX - not MSDOS',0
EINTR   db 'Interrupted function call',0
EIO     db 'Input/output error',0
ENXIO   db 'No such device or address',0
EAGAIN  db 'Resource temporarily unavailable',0
ENOTBLK db 'UNIX - not MSDOS',0
EBUSY   db 'Resource busy',0
ENOTDIR db 'UNIX - not MSDOS',0
EISDIR  db 'UNIX - not MSDOS',0
EUCLEAN db 'UNIX - not MSDOS',0
sys_end equ $

.code
perror proc,a:dword
  callp fprintf,stderr,a
  callp fprintf,stderr,": "
  xor eax,eax
  mov ax,errno
  .if eax>=sys_nerr
    callp fprintf,stderr,"Unknown Error\n"
  .else
    shl eax,2  ;*4
    mov eax,dptr[sys_errlist+eax]
    callp fprintf,stderr,"%s\n",eax
  .endif
  xor eax,eax
  ret
perror endp

end

