/*===========================================================================*\
| PULLSHEL.H - Header file for PULLC shell                  ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all of the prototypes, macros, enums,                    |
| typedefs and externs for PULLSHEL.C.                                        |
|   Copyright (c) 1989 by James H. LeMay, All rights reserved.                |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#undef MULTIWORKWNDWS             /* Change this to "#undef" to exclude code
                                     for multiple work windows in PULLWORK.C */

/*===========================================================================*\
                           PULLSTAT declarations
\*===========================================================================*/

/* Any of the keys can be modified. POPKEY and TOPKEY1 are defined in *\
\* PULLC20.H.                                                         */

#define ALTF 33   /* First menu */
#define ALTQ 16   /* Quit menu */
#define ALTX 45   /* Immediately exit program */

/*------------------ Set up your menu names here in order: ----------------*/
/* This is optional, but it sure helps you in not only understanding the
   program, but also makes it unquestionably easier to rearrange.
*/

enum mainmenunames {
    FIRST_MENU,    QUIT_MENU,
    NO_MAIN_MENU=255
};

#ifdef USE_SUBMENU_CODE
enum submenunames {
    MY_SUB_MENU,
    NO_SUB_MENU=255
};
#endif

#ifdef USE_MSGLINE_CODE
enum msglinenames {
    WORK_ML,  TOP_ML,   ALT_ML,   MAIN_ML,  SUB_ML,   DW_ML,    DE_ML,
    SEQ_ML,   HELP_ML,  FUNC_ML,
    NO_ML=0xFF
};
#endif

#ifdef USE_HELPWNDW_CODE
enum helpwndwnames {
    WORKWNDW_HW,       TOPLINE_HW,        MAINMENU_HW,       SUBMENU_HW,
    DATAWNDW_HW,
    NO_HW=255
};

enum helplinenames {                /* HL - helpline;  L  - last */
    HL_W1, HL_WL,                                   /* work window */
    HL_T1, HL_TL,                                   /* top menu */
    HL_M1, HL_ML,                                   /* main menu */
    HL_S1, HL_SL,                                   /* sub menu */
    HL_D1, HL_D2, HL_D3, HL_D4, HL_D5, HL_D6,       /* numeric data */
           HL_DL,
    NO_HL=255
};
#endif

#ifdef USE_DATAENTRY_CODE
enum datawndwnames {
    AUBYTE_DW,
    NO_DW=255
};
#endif

extern char filename[13];


/*===========================================================================*\
                           PULLDATA declarations
\*===========================================================================*/

extern char pathname[67];

enum dataentrynames {
    AINT_DE,
    NO_DE=255
};

/*---------------- Set up your error message lines here: ------------------*\
| Error messages are used for indicating that data entry was invalid or out |
| of range.  errmsgline[0] is reserved for custom error messages that you   |
| can create at runtime.  Messages up to INVALID_EM are reserved.           |
\*-------------------------------------------------------------------------*/
enum errmsgnames {
    USER_EM,
    INVALID_EM,
    MY_EM,
    NO_EM=255
};


/*===========================================================================*\
                            PULLDIR declarations
\*===========================================================================*/

#define FNAMESIZE 13      /* Size of a filename string variable */
#define MAXFILES 250      /* Size as large as you want your heap to be
                             available.   Uses 15 bytes per file name. */

typedef struct {
    char title[9];
    unsigned char menulines;
    unsigned char row,col,rows,cols;
    unsigned char hiliteline;
    unsigned char battr,wattr,hattr;
    int border;
    unsigned char msglinenum,helpwndwnum;
} dirmenu_t;

extern dirmenu_t dirmenu;
extern char filemask[FNAMESIZE];

/*  ----------   Prototypes from PULLSTAT.C   -----------  */

void getmainmenu( int name );
void savemainmenu(void);
void getsubmenu( int name );
void savesubmenu(void);
void sethelplines( int name, int first, int last );
void dummyfunc(void);
void gotodir(void);
void dodir(void);
void setquit(void);
void processthenpop(void);
void popthenprocess(void);
void popprocessandpull(void);
void popnumoflevels(void);
void poptonewmenu(void);
void datemenu1(void);
void datemenu2(void);
void datemenu3(void);
void getuserpullstats(void);
void getoverridestats(void);
void setworkwndw( int wn );
void checkglobalkeys(void);
void initpullstat(void);

/*  ----------   Prototypes from PULLDATA.C   -----------  */

void geterrmsgs(void);
void makeerrmsg( unsigned long low, unsigned long high, char sign );
void verifypath(void);
void verifyfilemask(void);
void verifypricelimit(void);
void verifymonth(void);
void verifyday(void);
void verifyyear(void);
void verifyyears(void);
void translatecase(void);
void verifybyte2(void);
void verifyubyte2(void);
void verifyint2(void);
void verifyuint2(void);
void verifylong2(void);
void verifydouble2(void);
void verifychar2(void);
void verifystring2(void);
void getdataentrystats(void);
void allocateheap(void);
void setdefaultcolors(void);
void initdatacolors(void);
int getjustify( int justify, int tod );
int getsetname( int sn, int tod );
void initdatadefaults(void);
void initpulldata(void);

/*  ----------   Prototypes from PULLDIR.C   -----------  */

void removespaces( char *str );
void dirqsort( int lower, int upper );
void sortdirectory(void);
void findfilenames(char *pathmask);
void getdirfilenames(void);
void showfilenames( int fli_new );
void maxpositive( int *num, int nummax );
void repositionlist( int fli_new, int hl_new );
void centernames( int *fli_new, int *hl_new, unsigned index );
void centerhilite(unsigned char mls, int *hl_new, int *fli_new);
void findclosematch( char *nametohilite, char *fn1, char *fn2, char *des,
                     int *index);
void showdirmenu( char *nametohilite );
void scandirbycursor(void);
void scandirbyletter(void);
void pulldirectory( char *nametochange, char *nametohilite );

/*  ----------   Prototypes from PULLWORK.C   -----------  */

void resetworkwndwstep(void);
void hideworkwndw(void);
void accessworkwndw( int wn );
void kbdidle(void);
void showfields(void);
void makeworkwndw2(void);
void editfields(void);
void initworkwndws(void);
void workwndw(void);
void initpullwork(void);

/*  ----------   Prototypes from MODNAME.C   -----------  */

void modfilename(void far *asciiz, void far *st);


