// BC4 defines for PMC v1.01 by Tran (a.k.a Thomas Pytel).

#ifndef __PMC_H
#define __PMC_H


// Basic types

#define NULL            0
#define FALSE           0
#define TRUE            1

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef void *          PTR;
typedef char *          STR;
typedef int             BOOL;


// General macros

#define loBYTE(w)               ((BYTE)(w)))
#define hiBYTE(w)               ((BYTE)((WORD)(w) >> 8))

#define loWORD(d)               ((WORD)(d))
#define hiWORD(d)               ((WORD)((DWORD)(d) >> 16))

#define makeWORD(l,h)           ((WORD)((BYTE)(h) << 8) + (BYTE)(l))
#define makeDWORD(l,h)          ((DWORD)((WORD)(h) << 16) + (WORD)(l))

#define max(a,b)                (((a) > (b)) ? (a) : (b))
#define min(a,b)                (((a) < (b)) ? (a) : (b))

#define mo(t,v)                 (*(t *)&(v))

#define rlp(d)                  ((PTR)((DWORD)(d) - database))
#define lnp(p)                  ((DWORD)(p) + database)
#define dcp(p)                  ((DWORD)(p) + code_data)
#define cdp(d)                  ((PTR)((DWORD)(d) + data_code))

#define SEGOFFtoPTR(so)         (DWORDtoPTR (mo (DWORD, (so))))
#define segofftoPTR(o,s)        (rlp (((WORD)(s) << 4) + (WORD)(o)))
#define PTRtooff(p)             ((WORD)(lnp (p) & 0xf))
#define PTRtoseg(p)             ((WORD)(lnp (p) >> 4))
#define PTRtoSEGOFF(so,p)       (mo (DWORD, (so)) = PTRtoDWORD (p))

#define SEGOFFtoDWORD(so)       (mo (DWORD, (so)))
#define segofftoDWORD           makeDWORD
#define DWORDtooff              loWORD
#define DWORDtoseg              hiWORD
#define DWORDtoSEGOFF(so,d)     (mo (DWORD, (so)) = (d))

#define PTRtoDWORD(p)           (((lnp (p) & 0xffff0) << 12) + \
                                 (lnp (p) & 0xf))
#define DWORDtoPTR(d)           (rlp ((DWORDtoseg (d) << 4) + DWORDtooff (d)))

// Memory and addresses

typedef struct
{
  WORD  off;
  WORD  seg;
} SEGOFF;

typedef struct
{
  DWORD off;
  WORD  sel;
} SELOFF;

typedef struct
{
  DWORD base;
  DWORD size;
  DWORD handle;
} MEMBLOCK;

typedef struct
{
  DWORD adx;
  DWORD size;
  BYTE  RESTART         : 1;
  BYTE  ALLOCATED       : 1;
  BYTE  LASTAREA        : 1;
  BYTE  CORRUPT         : 1;
  BYTE  UNINIT          : 1;
} WALKMBINF;


// Selectors and Descriptors

typedef struct
{
  BYTE  A               : 1;
  BYTE  WR              : 1;
  BYTE  EC              : 1;
  BYTE  CD              : 1;
  BYTE  must_be_1       : 1;
  BYTE  DPL             : 2;
  BYTE  P               : 1;
  BYTE  limit_h         : 4;
  BYTE  AVL             : 1;
  BYTE  must_be_0       : 1;
  BYTE  BD              : 1;
  BYTE  G               : 1;
} ACCESS;

typedef struct
{
  WORD  limit_l;
  WORD  base_l;
  BYTE  base_m;
  WORD  access;
  BYTE  base_h;
} DESCRIPTOR;

#define dscACCESS(dsc,v)        ((*(ACCESS *)&((DESCRIPTOR)(dsc)).access).v)


// Register data structure

typedef struct
{
  BYTE  CF              : 1;
  BYTE                  : 1;
  BYTE  PF              : 1;
  BYTE                  : 1;
  BYTE  AF              : 1;
  BYTE                  : 1;
  BYTE  ZF              : 1;
  BYTE  SF              : 1;
  BYTE                  : 1;
  BYTE  IF              : 1;
  BYTE  DF              : 1;
  BYTE  OF              : 1;
} FLAGS;

typedef struct
{
  DWORD EDI;
  DWORD ESI;
  DWORD EBP;
  DWORD reserved0;
  DWORD EBX;
  DWORD EDX;
  DWORD ECX;
  DWORD EAX;
  WORD  reserved1[5];
  DWORD CSIP;
  DWORD SSSP;
} DWORDREGS;

typedef struct
{
  WORD  DI, reserved0;
  WORD  SI, reserved1;
  WORD  BP, reserved2;
  WORD  reserved3[2];
  WORD  BX, reserved4;
  WORD  DX, reserved5;
  WORD  CX, reserved6;
  WORD  AX, reserved7;
  WORD  FLAGS;
  WORD  ES;
  WORD  DS;
  WORD  FS;
  WORD  GS;
  WORD  IP;
  WORD  CS;
  WORD  SP;
  WORD  SS;
} WORDREGS;

typedef struct
{
  BYTE  reserved0[16];
  BYTE  BL, BH, reserved1[2];
  BYTE  DL, DH, reserved2[2];
  BYTE  CL, CH, reserved3[2];
  BYTE  AL, AH;
} BYTEREGS;

typedef union
{
  DWORDREGS d;
  WORDREGS w;
  BYTEREGS b;
} REGSTRUCT;

#define rsFLAGS(rs,v)   ((*(FLAGS *)&((REGSTRUCT)(rs)).w.flags).v)

#define fCF             0x0001
#define fPF             0x0004
#define fAF             0x0010
#define fZF             0x0040
#define fSF             0x0080
#define fIF             0x0200
#define fDF             0x0400
#define fOF             0x0800
#define fSTD            (fCF | fPF | fZF | fSF | fOF)


// System variables

extern  int             _PMpagetables;
extern  int             _PMselectors;
extern  int             _PMrmstacklen;
extern  int             _PMpmstacklen;
extern  int             _PMrmstacks;
extern  int             _PMpmstacks;
extern  int             _PMcallbacks;
extern  int             _pmcrmstacklen;
extern  int             _pmcrmstacks;
extern  int             _rmcpmstacklen;
extern  int             _rmcpmstacks;

extern  int             _stklen;
extern  int             _lowheaplen;
extern  int             _extheapmin;
extern  int             _extheapmax;
extern  int             _minosversion;
extern  PTR             _lowbufptr;
extern  int             _lowbuflen;

extern  DWORD           codebase;
extern  DWORD           database;
extern  DWORD           pspbase;
extern  DWORD           envbase;
extern  int             codesel;
extern  int             datasel;
extern  int             pspsel;
extern  int             envsel;
extern  int             zerosel;
extern  int             _TEXTseg;
extern  int             _DATAseg;
extern  int             _BSSseg;
extern  int             pspseg;
extern  int             envseg;
extern  PTR             zeroptr;
extern  DWORD           data_code;
extern  DWORD           code_data;

extern  int             osversion;
extern  BYTE            osminor;
extern  BYTE            osmajor;
extern  int             DPMIversion;
extern  BYTE            DPMIminor;
extern  BYTE            DPMImajor;

extern  int             CPL;
extern  int             selinc;
extern  int             PMtype;
extern  int             processor;
extern  BYTE            PICtable[2];
extern  BYTE            PICmaster;
extern  BYTE            PICslave;

extern  SEGOFF          rmstate;
extern  SEGOFF          rmswitch;
extern  SELOFF          pmstate;
extern  SELOFF          pmswitch;
extern  int             statesize;

extern  DWORD           pmcrmnoregs;
extern  DWORD           pmcrmregs;
extern  DWORD           pmcrminoregs;
extern  DWORD           pmcrmiregs;
extern  SEGOFF          rmcpmnoregs;
extern  SEGOFF          rmcpmregs;
extern  SEGOFF          rmcpminoregs;
extern  SEGOFF          rmcpmiregs;

extern  DWORD           pmstacklen;
extern  PTR             pmstackbase;
extern  PTR volatile    pmstacktop;
extern  int             rmstacklen;
extern  int             rmstackbase;
extern  int volatile    rmstacktop;

extern  MEMBLOCK        lowheapblock;
extern  MEMBLOCK        extheapblock;
extern  REGSTRUCT       rs;


// DPMI function error codes

#define _DPMI09ERROR            -32768

#define _DPMIUNSUPPORTED        -32767
#define _DPMIBADSTATE           -32766
#define _DPMISYSINTEGRITY       -32765
#define _DPMIDEADLOCK           -32764
#define _DPMICANCELLED          -32763

#define _DPMINORESOURCE         -32752
#define _DPMINODESCRIPTOR       -32751
#define _DPMINOLINEARMEM        -32750
#define _DPMINOPHYSICALMEM      -32749
#define _DPMINOBACKINGSTORE     -32748
#define _DPMINOCALLBACK         -32747
#define _DPMINOHANDLE           -32746

#define _DPMILOCKEXCEEDED       -32745
#define _DPMIRESOURCEEXCLUSIVE  -32744
#define _DPMIRESOURCESHARED     -32743

#define _DPMIBADVALUE           -32735
#define _DPMIBADSELECTOR        -32734
#define _DPMIBADHANDLE          -32733
#define _DPMIBADCALLBACK        -32732
#define _DPMIBADLINEARADDRESS   -32731
#define _DPMIBADREQUEST         -32730

// DOS function error codes

#define _DOSBADFUNCTION         -65535
#define _DOSBADFILE             -65534
#define _DOSBADPATH             -65533
#define _DOSNOHANDLES           -65532
#define _DOSACCESSDENIED        -65531
#define _DOSBADHANDLE           -65530
#define _DOSNOMEM               -65528
#define _DOSBADENV              -65526
#define _DOSBADFORMAT           -65525
#define _DOSBADACCESSCODE       -65524
#define _DOSBADDRIVE            -65521
#define _DOSCURRENTDIR          -65520
#define _DOSNOTSAMEDEVICE       -65519
#define _DOSNOMOREFILES         -65518

// File open mode codes

#define RDONLY          0
#define WRONLY          1
#define RDWR            2

// File seek from codes

#define SEEK_SET        0
#define SEEK_CUR        1
#define SEEK_END        2

// File find attributes and mode

#define FA_NORMAL       0x00
#define FA_RDONLY       0x01
#define FA_HIDDEN       0x02
#define FA_SYSTEM       0x04
#define FA_LABEL        0x08
#define FA_DIREC        0x10
#define FA_ARCH         0x20

#define FF_FIRST        0x4e
#define FF_NEXT         0x4f

// IRQ mask values

#define IRQENABLED      0
#define IRQDISABLED     1

// Code stub types

#define RMSTUBINRI      0
#define RMSTUBINRC      1
#define RMSTUBFNRI      2
#define RMSTUBFNRC      3
#define RMSTUBIRI       4
#define RMSTUBIRC       5
#define RMSTUBFRI       6
#define RMSTUBFRC       7

#define RMSTUBNRLEN     0x20
#define RMSTUBRLEN      0xc0
#define PMSTUBLEN       0x48
#define CBSTUBLEN       0x38

// IRQ types

#define IRQI            0
#define IRQC            1
#define IRQOWN          2

#define IRQILEN         RMSTUBNRLEN
#define IRQCLEN         (RMSTUBNRLEN + PMSTUBLEN)
#define IRQOWNLEN       0

// Functions

#ifdef __cplusplus
extern "C" {
#endif

// DPMI functions

long  __pascal dsc_alloc (WORD *sel, int count);
long  __pascal dsc_free (WORD sel);
long  __pascal dsc_getbase (WORD sel, DWORD *base);
long  __pascal dsc_setbase (WORD sel, DWORD base);
long  __pascal dsc_getlimit (WORD sel, DWORD *limit);
long  __pascal dsc_setlimit (WORD sel, DWORD limit);
long  __pascal dsc_getaccess (WORD sel, WORD *access);
long  __pascal dsc_setaccess (WORD sel, WORD access);
long  __pascal dsc_alias (WORD src, WORD *dst);
long  __pascal dsc_getdsc (WORD sel, DESCRIPTOR *dsc);
long  __pascal dsc_setdsc (WORD sel, DESCRIPTOR *dsc);

void  __pascal iv_rmget (int intr, SEGOFF *iv);
void  __pascal iv_rmset (int intr, WORD off, WORD seg);
void  __pascal iv_pmget (int intr, SELOFF *iv);
long  __pascal iv_pmset (int intr, DWORD off, WORD sel);

long  __cdecl  xlt_simrmint (int intr, REGSTRUCT *rs, int count, ...);
long  __cdecl  xlt_callrmfar (REGSTRUCT *rs, int count, ...);
long  __cdecl  xlt_callrmiret (REGSTRUCT *rs, int count, ...);
long  __pascal xlt_rmcballoc (SEGOFF *cb, DWORD rsoff, WORD rssel, DWORD funcoff, WORD funcsel);
long  __pascal xlt_rmcbfree (DWORD cbsegoff);

DWORD __pascal mb_info (void);
long  __pascal mb_alloc (MEMBLOCK *mb, DWORD size);
long  __pascal mb_free (MEMBLOCK *mb);
long  __pascal mb_resize (MEMBLOCK *mb, DWORD size);

// Memory block functions

DWORD __pascal coreleft (void);
PTR   __pascal malloc (DWORD size);
PTR   __pascal realloc (PTR ptr, DWORD size);
void  __pascal free (PTR ptr);

BOOL  __pascal mbinit (MEMBLOCK *mb);
DWORD __pascal mbsquish (MEMBLOCK *mb);
void  __pascal mbunsquish (MEMBLOCK *mb, DWORD size);

PTR   __pascal mbmalloc (MEMBLOCK *mb, DWORD size);
PTR   __pascal mbrealloc (MEMBLOCK *mb, PTR ptr, DWORD size);
void  __pascal mbfree (MEMBLOCK *mb, PTR ptr);

DWORD __pascal mbcoreleft (MEMBLOCK *mb);
BOOL  __pascal mbcheck (MEMBLOCK *mb);
DWORD __pascal mbgetsize (MEMBLOCK *mb, PTR ptr);
void  __pascal mbwalk (MEMBLOCK *mb, WALKMBINF *inf);

#define locoreleft() (mbcoreleft (&lowheapblock))
#define lomalloc(size) (mbmalloc (&lowheapblock, size))
#define lorealloc(ptr, size) (mbrealloc (&lowheapblock, ptr, size))
#define lofree(ptr) (mbfree (&lowheapblock, ptr))

#define hicoreleft() (mbcoreleft (&extheapblock))
#define himalloc(size) (mbmalloc (&extheapblock, size))
#define hirealloc(ptr, size) (mbrealloc (&extheapblock, ptr, size))
#define hifree(ptr) (mbfree (&extheapblock, ptr))

// Memory functions

PTR   __pascal memccpy (PTR dst, PTR src, int c, DWORD size);
BOOL  __pascal memchk (PTR mem, int c, DWORD size);
PTR   __pascal memchr (PTR mem, int c, DWORD size);
int   __pascal memcmp (PTR mem1, PTR mem2, DWORD size);
PTR   __pascal memcpy (PTR dst, PTR src, DWORD size);
int   __pascal memicmp (PTR mem1, PTR mem2, DWORD size);
PTR   __pascal memmove (PTR dst, PTR src, DWORD size);
PTR   __pascal memset (PTR mem, int c, DWORD size);

#define movmem(src, dst, size) (void)memmove (dst, src, size)
#define setmem(dst, size, val) (void)memset (dst, val, size)

// String functions

STR   __pascal stpcpy (STR dst, STR src);
STR   __pascal strcat (STR dst, STR src);
STR   __pascal strchr (STR str, int c);
int   __pascal strcmp (STR str1, STR str2);
STR   __pascal strcpy (STR dst, STR src);
DWORD __pascal strcspn (STR str1, STR str2);
STR   __pascal strdup (STR str);
int   __pascal stricmp (STR str1, STR str2);
DWORD __pascal strlen (STR str);
STR   __pascal strlwr (STR str);
STR   __pascal strncat (STR dst, STR src, DWORD maxlen);
int   __pascal strncmp (STR str1, STR str2, DWORD maxlen);
STR   __pascal strncpy (STR dst, STR src, DWORD maxlen);
int   __pascal strnicmp (STR str1, STR str2, DWORD maxlen);
STR   __pascal strnset (STR str, int c, DWORD maxlen);
STR   __pascal strpbrk (STR str1, STR str2);
STR   __pascal strrchr (STR str, int c);
STR   __pascal strrev (STR str);
STR   __pascal strset (STR str, int c);
DWORD __pascal strspn (STR str1, STR str2);
STR   __pascal strstr (STR str1, STR str2);
STR   __pascal strupr (STR str);

#define strcmpi(str1, str2) stricmp (str1, str2)
#define strncmpi(str1, str2, maxlen) strnicmp (str1, str2, maxlen)

// Intrinsic memory and string functions

PTR   __memchr__ (PTR mem, int c, DWORD size);
int   __memcmp__ (PTR mem1, PTR mem2, DWORD size);
PTR   __memcpy__ (PTR dst, PTR src, DWORD size);
PTR   __memset__ (PTR mem, int c, DWORD size);
STR   __stpcpy__ (STR dst, STR src);
STR   __strcat__ (STR dst, STR src);
STR   __strchr__ (STR str, int c);
int   __strcmp__ (STR str1, STR str2);
STR   __strcpy__ (STR dst, STR src);
DWORD __strlen__ (STR str);
STR   __strncat__ (STR dst, STR src, DWORD maxlen);
int   __strncmp__ (STR str1, STR str2, DWORD maxlen);
STR   __strncpy__ (STR dst, STR src, DWORD maxlen);
STR   __strnset__ (STR str, int c, DWORD n);
STR   __strrchr__ (STR str, int c);
STR   __strset__ (STR str, int c);

#define memchr_ __memchr__
#define memcmp_ __memcmp__
#define memcpy_ __memcpy__
#define memset_ __memset__
#define stpcpy_ __stpcpy__
#define strcat_ __strcat__
#define strchr_ __strchr__
#define strcmp_ __strcmp__
#define strcpy_ __strcpy__
#define strlen_ __strlen__
#define strncat_ __strncat__
#define strncmp_ __strncmp__
#define strncpy_ __strncpy__
#define strnset_ __strnset__
#define strrchr_ __strrchr__
#define strset_ __strset__

// File functions

long  __pascal fileopen (STR fnm, int mode);
long  __pascal filecreate (STR fnm);
long  __pascal fileclose (WORD handle);
long  __pascal filelseek (WORD handle, long off, int from);
long  __pascal fileread (WORD handle, PTR buf, long size);
long  __pascal filewrite (WORD handle, PTR buf, long size);

long  __pascal filedelete (STR fnm);
long  __pascal filefind (STR buf, STR mask, int mode, int attr);
long  __pascal filesize (WORD handle);
long  __pascal filerename (STR dst, STR src);
long  __pascal filecopy (WORD dst, WORD src, long size);

long  __pascal fileexec (STR fnm, STR cline);

long  __pascal dircurrent (STR buf);
long  __pascal dircreate (STR dir);
long  __pascal dirdelete (STR dir);
long  __pascal dirchange (STR dir);

long  __pascal drivecurrent (void);
long  __pascal drivechange (int drive);
long  __pascal drivesize (int drive);
long  __pascal drivefree (int drive);

// IRQ and mode switch functions

BOOL  __pascal callrmnrint (int intr);
BOOL  __pascal callrmnrfar (DWORD segoff);
BOOL  __pascal callrmnriret (DWORD segoff);
BOOL  __pascal callrmrint (int intr);
BOOL  __pascal callrmrfar (DWORD segoff);
BOOL  __pascal callrmriret (DWORD segoff);

void  __pascal setrmstub (PTR stub, void (*func) (void), int type);
void  __pascal setpmstub (PTR stub, void (*func) (void));
void  __pascal setcbstub (PTR stub, REGSTRUCT *__pascal (*func) (REGSTRUCT *r));

PTR   __pascal setcb (SEGOFF *cb, PTR stub, REGSTRUCT *rs, REGSTRUCT *__pascal (*func) (REGSTRUCT *r));
void  __pascal resetcb (DWORD cbsegoff, PTR stub);

PTR   __pascal setirq (int irq, SEGOFF *ormiv, SELOFF *opmiv, PTR stub, DWORD segoff, void (*func) (void), int type);
void  __pascal resetirq (int irq, SEGOFF *ormiv, SELOFF *opmiv, PTR stub);

BOOL  __pascal getirqmask (int irq);
void  __pascal setirqmask (int irq, BOOL status);

// Other functions

void  __emit__ (BYTE, ...);
#define emit_ __emit__

#define cli_ __emit__ (0xfa)
#define sti_ __emit__ (0xfb)

BOOL  __pascal kbhit (void);
WORD  __pascal getch (void);

STR   __pascal getenv (STR var);
STR   __pascal getexe (void);

long  __pascal dosfunc (STR str, int AXval);
long  __pascal dosputstr (STR str);

void  __pascal exit (int retval);

#ifdef __cplusplus
}
#endif

#endif  /* __PMC_H */

