/*
  ͻ
                                                                          
                                Piano Scene                               
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

typedef char name[32];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                             Piano  Scene                               \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    2\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.300\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.200\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 -750.000  395.000\n");
  fprintf(textdiskfile,"   ROTATE  =   -1.500\n");
  fprintf(textdiskfile,"   TILT    =   22.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MATTEWALL\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.400    0.400    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MIRROR\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   GLOSS   =   40.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = EBONY\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.350    0.350    0.350\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =    1.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = IVORY\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    2.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = ITALIANMARBLE\n");
  fprintf(textdiskfile,"   TEXTURE = MARBLE\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = OAKWOOD\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.520    0.320    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.050    0.050    0.050\n");
  fprintf(textdiskfile,"   GLOSS   =    3.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = ITALIANMARBLE\n");
}

void make()
{
  int t;
  float xloc;
  Byte c;

  writestudio();
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ end wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000  300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  600.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ left wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000 -300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =    0.000  600.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ right wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =  300.000  300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =    0.000 -600.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ ceiling }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000  300.000  400.000\n");
  fprintf(textdiskfile,"   V1      =  600.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000 -600.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ piano inside }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =  -140.000   200.000   80.000\n");
  fprintf(textdiskfile,"   BASERAD =    20.000\n");
  fprintf(textdiskfile,"   APEXLOC =  -140.000   200.000  140.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     =  -140.000   200.000  140.000\n");
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  1.000  0.000\n");
  fprintf(textdiskfile,"   RADIUS  =  20.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =   -20.000  200.000   80.000\n");
  fprintf(textdiskfile,"   BASERAD =    20.000\n");
  fprintf(textdiskfile,"   APEXLOC =   -20.000  200.000  140.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -20.000  200.000  140.000\n");
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  1.000  0.000\n");
  fprintf(textdiskfile,"   RADIUS  =  20.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =   80.000  -130.000   80.000\n");
  fprintf(textdiskfile,"   BASERAD =   20.000\n");
  fprintf(textdiskfile,"   APEXLOC =   80.000  -130.000  140.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     =  80.000  -130.000  140.000\n");
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  1.000  0.000\n");
  fprintf(textdiskfile,"   RADIUS  =  20.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ piano top }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000 -150.000  140.000\n");
  fprintf(textdiskfile,"   V1      =  160.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  350.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -140.000  200.000  140.000\n");
  fprintf(textdiskfile,"   V1      =  120.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000   20.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"TRIANGLE\n");
  fprintf(textdiskfile,"   LOC     =   99.120 -124.200  140.000\n");
  fprintf(textdiskfile,"   V1      = -100.000  330.000    0.000\n");
  fprintf(textdiskfile,"   V2      = -100.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =    0.000 -150.000  140.000\n");
  fprintf(textdiskfile,"   V1      =   80.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000   40.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ piano sides }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000  200.000   80.000\n");
  fprintf(textdiskfile,"   V1      =    0.000 -350.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   60.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =  -20.000  220.000   80.000\n");
  fprintf(textdiskfile,"   V1      = -120.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   60.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000 -150.000   80.000\n");
  fprintf(textdiskfile,"   V1      =  240.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   60.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =   99.120 -124.200   80.000\n");
  fprintf(textdiskfile,"   V1      = -100.000  330.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   60.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ piano legs }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =  -140.000    200.000    0.000\n");
  fprintf(textdiskfile,"   BASERAD =     8.000\n");
  fprintf(textdiskfile,"   APEXLOC =  -140.000    200.000   80.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =   -20.000    200.000    0.000\n");
  fprintf(textdiskfile,"   BASERAD =     8.000\n");
  fprintf(textdiskfile,"   APEXLOC =   -20.000    200.000   80.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =   80.000   -130.000    0.000\n");
  fprintf(textdiskfile,"   BASERAD =    8.000\n");
  fprintf(textdiskfile,"   APEXLOC =   80.000   -130.000   80.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -140.000   -130.000    0.000\n");
  fprintf(textdiskfile,"   BASERAD =    8.000\n");
  fprintf(textdiskfile,"   APEXLOC = -140.000   -130.000   80.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ piano keyboard }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000 -150.000   70.000\n");
  fprintf(textdiskfile,"   V1      =    0.000  -70.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   30.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =   80.000 -150.000   70.000\n");
  fprintf(textdiskfile,"   V1      =    0.000    0.000   30.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  -70.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000 -220.000   70.000\n");
  fprintf(textdiskfile,"   V1      =  240.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000   30.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -160.000 -220.000  100.000\n");
  fprintf(textdiskfile,"   V1      =  240.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000   70.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"     { white keys }\n");
  fprintf(textdiskfile,"\n");
  for (t = 0; t <= 27; t++)
  {
    xloc = -160.0 + t * 8.5 + 0.5;
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"PARALLELOGRAM\n");
    fprintf(textdiskfile,"   LOC     = %f -220.000  102.000\n",xloc);
    fprintf(textdiskfile,"   V1      =    7.500    0.000    0.000\n");
    fprintf(textdiskfile,"   V2      =    0.000   32.000    0.000\n");
    fprintf(textdiskfile,"   MATL    = IVORY\n");
  }
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"     { black keys }\n");
  fprintf(textdiskfile,"\n");
  c = 0;
  for (t = 0; t <= 26; t++)
  {
    xloc = -160.0 + t * 8.5 + 4.25 + 0.5 + 1.625 + 0.5;
    c = c + 1;
    if (!((c == 3) || (c == 7)))
    {
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"PARALLELOGRAM\n");
      fprintf(textdiskfile,"   LOC     = %3.3f -208.000  104.000\n",xloc);
      fprintf(textdiskfile,"   V1      =    3.250    0.000    0.000\n");
      fprintf(textdiskfile,"   V2      =    0.000   20.000    0.000\n");
      fprintf(textdiskfile,"   MATL    = EBONY\n");
    }
    if ((c == 7))
      c = 0;
  }
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ mirror on wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -150.000  280.000  130.000\n");
  fprintf(textdiskfile,"   V1      =  300.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  150.000\n");
  fprintf(textdiskfile,"   MATL    = MIRROR\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ lamps on ceiling }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  -100.000 -200.000  395.000\n");
  fprintf(textdiskfile,"   RADIUS  =   25.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.600    0.600    0.550\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  100.000  250.000  395.000\n");
  fprintf(textdiskfile,"   RADIUS  =   25.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.600    0.600    0.550\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename,"PIANO.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}