/*
  ͻ
                                                                          
                                  Orbit                                   
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ

          Diam (mi)  Mass (1.00 Earth)  Period around Sun  Dist from Sun (mi)
Sun        864,000     332,000
Mercury      3,010           0.0543         88    days             38,130,000
Venus        7,610           0.8136        224.7  days             67,890,000
Earth        7,927           1.000         365.24 days             93,000,000
Moon         2,160           0.0123                        (Earth)    238,857
Mars         4,140           0.1069        687    days            152,520,000
Jupiter     86,900         318.35           11.86 years           499,410,000
Saturn      71,500          95.3            29.46 years           928,140,000
Uranus      29,500          14.54           84.00 years         1,819,080,000
Neptune     26,800          17.2           164.8  years         2,807,670,000
Pluto        3,600           0.033         248.4  years         2,915,000,000


Since a properly scaled model would not look attractive here, the planet
  distances to the sun are scaled by 500,000 and the planet diameters
  are scaled by 1000.  The sun is scaled by 35,000.  The moon's distance
  from Earth is scaled by 15,000.  Note that planets are all co-planer -
  this is not the case in reality.  Peroids of the planets are also slightly
  altered to allow for 30 frames of animation.

*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float sind(Word a)
{
  return sin(a * piover180);
}

float cosd(Word a)
{
  return cos(a * piover180);
}

typedef char name[81];

FILE *Out_File;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(Out_File,"ͻ\n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                                Orbit                                   \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                       by Christopher D. Watkins                        \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"ͼ\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"STATS\n");
  fprintf(Out_File,"   XRES    = %d\n",xresolution);
  fprintf(Out_File,"   YRES    = %d\n",yresolution);
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"FRAMES\n");
  fprintf(Out_File,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"ENVIRONMENT\n");
  fprintf(Out_File,"   LOCLWGT =    0.900    0.900    0.900\n");
  fprintf(Out_File,"   REFLWGT =    0.100    0.100    0.100\n");
  fprintf(Out_File,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(Out_File,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(Out_File,"   RDEPTH  =    1\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMPS\n");
  fprintf(Out_File,"   REFLAMP = FALSE\n");
  fprintf(Out_File,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   DISTEFF =    0.050\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"OBSERVER\n");
  fprintf(Out_File,"   FLENGTH =    3.300\n");
  fprintf(Out_File,"   OBSPOS  =    0.000  -500.000  300.000\n");
  fprintf(Out_File,"   ROTATE  =    0.000\n");
  fprintf(Out_File,"   TILT    =   31.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = MERCURY\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.400    0.350    0.350\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.400    0.400\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = VENUS\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.400    0.400    0.350\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.600    0.300\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = EARTH\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.350    0.350    0.400\n");
  fprintf(Out_File,"   DIFRFL  =    0.400    0.500    0.600\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = MOON\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.400    0.400    0.400\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = MARS\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.400    0.350    0.350\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.500    0.500\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File," { sun }\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   RADIUS  =   24.680\n");
  fprintf(Out_File,"   INTENS  =    0.980    0.940    0.840\n");
}

void make()
{
  Word t;
  float mercuryx, mercuryy, mercuryz, mercuryrad;
  float mercurydist, mercuryphase, mercurydelta;
  float venusx, venusy, venusz, venusrad;
  float venusdist, venusphase, venusdelta;
  float earthx, earthy, earthz, earthrad;
  float earthdist, earthphase, earthdelta;
  float moonx, moony, moonz, moonrad;
  float moondist, moonphase, moondelta;

  mercuryx = 0.0;
  mercuryy = 0.0;
  mercuryz = 0.0;
  mercuryrad = 6.020;
  mercurydist = 76.26;
  mercuryphase = 315.0;
  mercurydelta = (360.0 / numberofframes) * 4;
  venusx = 0.0;
  venusy = 0.0;
  venusz = 0.0;
  venusrad = 15.220;
  venusdist = 135.78;
  venusphase = 315.0;
  venusdelta = (360.0 / numberofframes) * 2;
  earthx = 0.0;
  earthy = 0.0;
  earthz = 0.0;
  earthrad = 15.854;
  earthdist = 186.0;
  earthphase = 315.0;
  earthdelta = (360.0 / numberofframes) * 1;
  moonx = 0.0;
  moony = 0.0;
  moonz = 0.0;
  moonrad = 4.320;
  moondist = 31.848;
  moonphase = 0.0;
  moondelta = (360.0 / numberofframes) * 24;
  for (t = 1; t <= numberofframes; t++)
  {
    writestudio();
    mercuryx = mercurydist * cosd((int)(mercuryphase) & 0xFFFF);
    mercuryy = mercurydist * sind((int)(mercuryphase) & 0xFFFF);
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File," { Mercury }\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",mercuryx,mercuryy,mercuryz);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",mercuryrad);
    fprintf(Out_File,"   MATL    = MERCURY\n");
    mercuryphase = mercuryphase + mercurydelta;
    venusx = venusdist * cosd((int)(venusphase) & 0xFFFF);
    venusy = venusdist * sind((int)(venusphase) & 0xFFFF);
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File," { Venus }\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",venusx,venusy,venusz);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",venusrad);
    fprintf(Out_File,"   MATL    = VENUS\n");
    venusphase = venusphase + venusdelta;
    earthx = earthdist * cosd((int)(earthphase) & 0xFFFF);
    earthy = earthdist * sind((int)(earthphase) & 0xFFFF);
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File," { Earth }\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",earthx,earthy,earthz);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",earthrad);
    fprintf(Out_File,"   MATL    = EARTH\n");
    earthphase = earthphase + earthdelta;
    moonx = earthx + moondist * cosd((int)(moonphase) & 0xFFFF);
    moony = earthy + moondist * sind((int)(moonphase) & 0xFFFF);
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File," { Earth Moon }\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"SPHERE\n");
    fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",moonx,moony,moonz);
    fprintf(Out_File,"   RADIUS  = %3.3f\n",moonrad);
    fprintf(Out_File,"   MATL    = MOON\n");
    moonphase = moonphase + moondelta;
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"ENDFRAME\n");
  }
}

void main()
{
  strcpy(filename,"Orbit.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  Out_File=fopen(filename, "wt");
  writeheader();
  make();
  fclose(Out_File);
}