/*
  ͻ
                                                                          
                         Bounce with Glass Spheres                        
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float SinD(Word a)
{
  return sin(a * piover180);
}

typedef char name[32];

FILE *Out_File;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(Out_File,"ͻ\n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                                Bounce 2                                \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                       by Christopher D. Watkins                        \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"ͼ\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"STATS\n");
  fprintf(Out_File,"   XRES    = %d\n",xresolution);
  fprintf(Out_File,"   YRES    = %d\n",yresolution);
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"FRAMES\n");
  fprintf(Out_File,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"ENVIRONMENT\n");
  fprintf(Out_File,"   LOCLWGT =    0.500    0.500    0.500\n");
  fprintf(Out_File,"   REFLWGT =    0.300    0.300    0.300\n");
  fprintf(Out_File,"   TRANWGT =    0.960    0.960    0.960\n");
  fprintf(Out_File,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(Out_File,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(Out_File,"   RDEPTH  =    4\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMPS\n");
  fprintf(Out_File,"   REFLAMP = FALSE\n");
  fprintf(Out_File,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   DISTEFF =    0.050\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"OBSERVER\n");
  fprintf(Out_File,"   FLENGTH =    3.200\n");
  fprintf(Out_File,"   OBSPOS  =    0.000 -660.000  220.000\n");
  fprintf(Out_File,"   ROTATE  =    0.000\n");
  fprintf(Out_File,"   TILT    =   16.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"SKY\n");
  fprintf(Out_File,"   HORCOL  =    0.100    0.150    0.200\n");
  fprintf(Out_File,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(Out_File,"   CLOUDS  = TRUE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = PLASTICTILE\n");
  fprintf(Out_File,"   TEXTURE = CHECKER\n");
  fprintf(Out_File,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(Out_File,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   GLOSS   =    8.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(Out_File,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TILE    =    0.012\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = GLASS\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.050    0.050    0.050\n");
  fprintf(Out_File,"   DIFRFL  =    0.050    0.050    0.050\n");
  fprintf(Out_File,"   SPCRFL  =    0.900    0.900    0.900\n");
  fprintf(Out_File,"   GLOSS   =   65.000\n");
  fprintf(Out_File,"   TRANS   =    0.900    0.900    0.900\n");
  fprintf(Out_File,"   INDEX   =    1.510\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"GROUND\n");
  fprintf(Out_File,"   MATL    = PLASTICTILE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     =  350.000 -350.000  350.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     = -350.000 -350.000  350.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  Word theta;
  float x, y, z1;
  float z2, z3;
  float zoffset;
  float rad;

  theta = 0;
  rad = 40.0;
  zoffset = rad;
  x = 0.0;
  y = 0.0;
  z1 = 0.0;
  z2 = 0.0;
  z3 = 0.0;
  for (theta = 0; theta <= 180; theta++)
  {
    if (((theta % (180 / numberofframes)) == 0))
    {
      writestudio();
      z1 = zoffset + 90 * SinD(theta);
      z2 = zoffset + 70 * fabs(SinD(theta + 30));
      z3 = zoffset + 50 * fabs(SinD(theta - 45));
      fprintf(Out_File,"\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"SPHERE\n");
      fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z1);
      fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
      fprintf(Out_File,"   MATL    = GLASS\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"SPHERE\n");
      fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",(x + 2.5 * rad),y,z2);
      fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
      fprintf(Out_File,"   MATL    = GLASS\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"SPHERE\n");
      fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",(x - 2.5 * rad),y,z3);
      fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
      fprintf(Out_File,"   MATL    = GLASS\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"BOUNDINGSPHERETEST\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"\n");
      fprintf(Out_File,"ENDFRAME\n");
    }
  }
}

void main()
{
  strcpy(filename,"BOUNCE2.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  Out_File=fopen(filename, "wt");
  writeheader();
  make();
  fclose(Out_File);
}