/*
  ͻ
                                                                          
         2 State Finite Closed 2-Dimensional Life Cellular Automation     
                                                                          
                          Life World File Maker                           
                                                                          
                     (c) 1991 Christopher D. Watkins                      
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"

#define MaxColumn 100
#define MaxRow 100
#define WorldTop (MaxColumn-1)
#define WorldSide (MaxRow-1)
#define States 2
#define MaxState (States-1)
#define Born 1
#define Dead 0

typedef char Name[33];
typedef Byte WorldArray[WorldTop+1][WorldSide+1];

Name WorldFileName;
FILE *WorldFile;
WorldArray World;
Word i, j, t;
Boolean o;

void ClearWorld()
{
  for(i=0; i<=(MaxColumn-1); i++)
  {
    for(j=0; j<=(MaxRow-1); j++)
      World[i][j]=Dead;
  }
}

void DoRandomWorld()
{
  for(i=0; i<=(MaxColumn-1); i++)
  {
    for(j=0; j<=(MaxRow-1); j++)
    {
      if(RandInt(5)==0)
	World[i][j]=Born;
      else
	World[i][j]=Dead;
    }
  }
}

void DoWalkerWorld()
{
  Word x, y, t;

  for(i=0; i<=((MaxColumn-1)/7); i++)
  {
    for(j=0; j<=((MaxRow-1)/7); j++)
    {
      t=(i+j)&1;
      if(!t)
      {
	x=4+i*7;
	y=2+j*7;
	World[x][y+2]=Born;
	World[x+1][y+2]=Born;
	World[x+2][y+2]=Born;
	World[x+2][y+1]=Born;
	World[x+1][y]=Born;
      }
    }
  }
}

void DoBloomerWorld()
{
  Word x, y, t;

  for(i=0; i<=(MaxColumn-1)/7; i++)
  {
    for(j=0; j<=(MaxRow-1)/7; j++)
    {
      t=(i+j)&1;
      if(!t)
      {
	x=2+i*7;
	y=2+j*7;
	World[x+1][y]=Born;
	World[x][y+1]=Born;
	World[x][y+2]=Born;
	World[x][y+3]=Born;
	World[x+1][y+3]=Born;
	World[x+2][y+3]=Born;
	World[x+2][y+2]=Born;
	World[x+2][y+1]=Born;
      }
    }
  }
}

void WriteWorldFile()
{
  fwrite(World, sizeof(World), 1, WorldFile);
  fclose(WorldFile);
}

void main()
{
  Boolean randomWorld=true;
  Boolean walkerWorld=false;
  Boolean bloomerWorld=false;

  clrscr();
  printf("Generating World\n");
  strcpy(WorldFileName, "LWORLD.CA");
  WorldFile=fopen(WorldFileName, "wb");
  InitRand(0.4231966);
  ClearWorld();
  if(randomWorld)
    DoRandomWorld();
  else if(walkerWorld)
    DoWalkerWorld();
  else if(bloomerWorld)
    DoBloomerWorld();
  WriteWorldFile();
}