/*
  ͻ
                                                                          
                              Clouds Generator                            
                                                                          
                          by Christopher D. Watkins                       
                                                                          
  ͼ
 */

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "math.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

void InitPalette3(Palette_Register color)  /*  plasmas  */
{
  #define mcol 63

  Byte i;

  color[0].Red=0;
  color[0].Grn=Round(mcol/85.0);
  color[0].Blu=mcol;
  for(i=1; i<=85; i++)
  {
    color[i].Red=0;
    color[i].Grn=Round((float)(i*mcol)/85.0);
    color[i].Blu=Round((float)((86-i)*mcol)/85.0);
    color[i+85].Red=Round((float)(i*mcol)/85.0);
    color[i+85].Grn=Round((float)((86-i)*mcol)/85.0);
    color[i+85].Blu=0;
    color[i+170].Red=Round((float)((86-i)*mcol)/85.0);
    color[i+170].Grn=0;
    color[i+170].Blu=Round((float)(i*mcol)/85.0);
  }
}

void InitPalette4(Palette_Register color)  /*  clouds  */
{
  #define mcol 63

  Word i;

  for(i=0; i<=255; i++)
  {
    color[i].Red=Round((float)(abs(i-127)*mcol)/127.0);
    color[i].Grn=Round((float)(abs(i-127)*mcol)/127.0);
    color[i].Blu=mcol;
  }
}

void InitPalette5(Palette_Register color)  /*  e-discharge  */
{
  #define mcol2 63.0

  Word i;

  for(i=0; i<=255; i++)
  {
    if(i<13)
    {
      color[i].Red=Round((float)(abs(i-12)/12.0)*mcol2);
      color[i].Grn=Round((float)(abs(i-12)/12.0)*mcol2/3.0);
      color[i].Blu=Round(mcol2/2.0);
    }
    else
    {
      color[i].Red=0;
      color[i].Grn=0;
      color[i].Blu=0;
    }
  }
}

void New_Col(int xa, int ya, int x, int y, int xb, int yb)
{
  long color;

  color=abs(xa-xb)+abs(ya-yb);
  color=RandInt(color<<1)-color;
  color=color+(Get_Pixel_2(xa, ya)+Get_Pixel_2(xb, yb)+1)>>1;
  if((color<1))
    color=1;
  else if ((color>255))
    color=255;
  if((Get_Pixel_2(x, y)==0))
      Plot(x, y, color);
}

void Sub_Divide(int x1, int y1, int x2, int y2)
{
  int x, y, color;

  if(!((x2-x1<2)&&(y2-y1<2)))
  {
    x=(x1+x2)>>1;
    y=(y1+y2)>>1;
    New_Col(x1, y1, x, y1, x2, y1);
    New_Col(x2, y1, x2, y, x2, y2);
    New_Col(x1, y2, x, y2, x2, y2);
    New_Col(x1, y1, x1, y, x1, y2);
    color=(Get_Pixel_2(x1, y1)+Get_Pixel_2(x2, y1)+
	   Get_Pixel_2(x2, y2)+Get_Pixel_2(x1, y2)+2)>>2;
    Plot(x, y, color);
    Sub_Divide(x1, y1, x, y);
    Sub_Divide(x, y1, x2, y);
    Sub_Divide(x, y, x2, y2);
    Sub_Divide(x1, y, x, y2);
  }
}

/*
  ͻ
                            Main Program                                  
  ͼ
*/

Palette_Register Pal_Array;

void main()
{
  InitRand(0.4231967);
  Init_Graphics(19);

/* plasmas */
/* InitPalette3(Pal_Array); */

/* clouds  */
 InitPalette4(Pal_Array);

/* electrical discharge */
/* InitPalette5(Pal_Array); */


  Set_Palette(Pal_Array);
  Plot(0, 0, RandInt(254)+1);
  Plot(XRes-1, 0, RandInt(254)+1);
  Plot(XRes-1, YRes-1, RandInt(254)+1);
  Plot(0, YRes-1, RandInt(254)+1);
  Sub_Divide(0, 0, XRes-1, YRes-1);
  do
  {
    Cycle_Palette(Pal_Array);
  }
  while (!kbhit());
  Exit_Graphics();
}