/*
  ͻ
                                                                          
          8 State Finite Closed 2-Dimensional Cellular Automation         
                                                                          
                     (c) 1991 Christopher D. Watkins                      
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

#define MaxColumn 100
#define MaxRow 100
#define States 8
#define MaxState (States-1)
#define WorldTop (MaxColumn-1)
#define WorldSide (MaxRow-1)

typedef Byte WorldArray[WorldTop+1][WorldSide+1];
typedef Byte Rule[8][8][8][8][8];

WorldArray NewWorld;
WorldArray OldWorld;
WorldArray TempWorld;
Rule Rules;

void DoWorld()
{
  Word i, j;
  Byte col;
  Boolean LowI, HighI;
  Boolean LowJ, HighJ;

  for(i=0; i<=WorldTop; i++)
  {
    LowI=(i==0);
    HighI=(i==WorldTop);
    for(j=0; j<=WorldSide; j++)
    {
      LowJ=(j==0);
      HighJ=(j==WorldSide);
      /*  Mod operations can be used here -  */
      /*  but the logical testing is faster  */
      if(!(LowI||HighI||LowJ||HighJ))
	NewWorld[i][j]=Rules[OldWorld[i][j-1]]
			    [OldWorld[i-1][j]]
			    [OldWorld[i][j]]
			    [OldWorld[i+1][j]]
			    [OldWorld[i][j+1]];
      else
      {
	if((LowI||HighI)&& !(LowJ||HighJ))
	{
	  if (LowI)
	    NewWorld[i][j]=Rules[OldWorld[i][j-1]]
				[OldWorld[WorldTop][j]][OldWorld[i][j]]
				[OldWorld[i+1][j]]
				[OldWorld[i][j+1]];
	  else
	    NewWorld[i][j]=Rules[OldWorld[i][j-1]]
				[OldWorld[i-1][j]]
				[OldWorld[i][j]]
				[OldWorld[0][j]]
				[OldWorld[i][j+1]];
	}
	else
	{
	  if((LowJ||HighJ)&& !(LowI||HighI))
	  {
	    if(LowJ)
	      NewWorld[i][j]=Rules[OldWorld[i][WorldSide]]
				  [OldWorld[i-1][j]]
				  [OldWorld[i][j]]
				  [OldWorld[i+1][j]]
				  [OldWorld[i][j+1]];
	    else
	      NewWorld[i][j]=Rules[OldWorld[i][j-1]]
				  [OldWorld[i-1][j]]
				  [OldWorld[i][j]]
				  [OldWorld[i+1][j]]
				  [OldWorld[i][0]];
	  }
	  else
	  {
	    if(LowI&&LowJ)
	      NewWorld[i][j]=Rules[OldWorld[i][WorldSide]]
				  [OldWorld[i+1][WorldSide]]
				  [OldWorld[i][j]]
				  [OldWorld[i+1][j]]
				  [OldWorld[i][j+1]];
	    else
	    {
	      if(LowI&&HighJ)
		NewWorld[i][j]=Rules[OldWorld[i][j-1]]
				    [OldWorld[WorldTop][j]]
				    [OldWorld[i][j]]
				    [OldWorld[i+1][j]]
				    [OldWorld[i][0]];
	      else
	      {
		if(HighI&&LowJ)
		  NewWorld[i][j]=Rules[OldWorld[i][WorldSide]]
				      [OldWorld[i-1][j]]
				      [OldWorld[i][j]]
				      [OldWorld[0][j]]
				      [OldWorld[i][j+1]];
		else
		  NewWorld[i][j]=Rules[OldWorld[i][j-1]]
				      [OldWorld[i-1][j]]
				      [OldWorld[i][j]]
				      [OldWorld[0][j]]
				      [OldWorld[i][0]];
	      }
	    }
	  }
	}
      }
      Plot(i, j, (NewWorld[i][j]<<5)&0xFF);
    }
  }
  memcpy(TempWorld, NewWorld, sizeof(NewWorld));
  memcpy(NewWorld, OldWorld, sizeof(OldWorld));
  memcpy(OldWorld, TempWorld, sizeof(TempWorld));
}

typedef char Name[33];

Name WorldFileName;
FILE *WorldFile;

void LoadWorld()
{
  Word i, j;

  fread(OldWorld, sizeof(OldWorld), 1, WorldFile);
  fclose(WorldFile);
}

Name RulefileName;
FILE *Rulefile;

void LoadRules()
{
  fread(Rules, sizeof(Rules), 1, Rulefile);
  fclose(Rulefile);
}

void ClearMemory()
{
  Word i, j, k, l, m;

  for(i=0; i<=WorldTop; i++)
  {
    for(j=0; j<=WorldSide; j++)
    {
      NewWorld[i][j]=0;
      OldWorld[i][j]=0;
      TempWorld[i][j]=0;
    }
  }
  for(i=0; i<=MaxState; i++)
  {
    for(j=0; j<=MaxState; j++)
    {
      for(k=0; k<=MaxState; k++)
      {
	for(l=0; l<=MaxState; l++)
	{
	  for(m=0; m<=MaxState; m++)
	      Rules[i][j][k][l][m]=0;
	}
      }
    }
  }
}

Palette_Register PalArray;

void main()
{
  ClearMemory();
  strcpy(WorldFileName,"WORLD2D.CA");
  strcpy(RulefileName,"RULE2D.CA");
  WorldFile=fopen(WorldFileName, "rb");
  Rulefile=fopen(RulefileName, "rb");
  LoadRules();
  LoadWorld();
  Init_Graphics(19);
  Init_Palette_2(PalArray);
  Set_Palette(PalArray);
  while(!kbhit())
    DoWorld();
  Exit_Graphics();
}