/*
  ͻ
                                                                          
                 Three-Dimensional Iterated Function Systems              
                                                                          
                         By Christopher D. Watkins                        
                                                                          
  ͼ
*/


#include "stdio.h"
#include "stdlib.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"


/* Map Num =  1     2     3     4     5     6     7     8  */

/* Translation */
float h[8]={-0.2,  1.0,  0.5, -0.1,  0.4, -0.2,  0.5, -0.4};
float k[8]={ 0.1, -0.1, 0.86, -0.6,  0.5, 0.76, -0.6, -0.2};
float l[8]={ 0.4,  0.1, -0.5,  0.4,  0.2,  0.8,  0.7,  0.1};

/* Rotation */
float th[8]={20.0,  120.0,  120.0,  20.0,  70.0,  6.0,  25.0,  40.0}; /* x & yz */
float ph[8]={10.0,   10.0,  -20.0,  70.0,  20.0, 20.0,  60.0,  10.0}; /* yz */

/* Scaling */
float r[8]={0.5, 0.5, 0.4, 0.1, 0.4, 0.4, 0.5, 0.2};
float s[8]={0.5, 0.7, 0.2, 0.4, 0.5, 0.8, 0.9, 0.5};
float t[8]={0.1, 0.1, 0.2, 0.5, 0.7, 0.2, 0.1, 0.2};


float RCosTh[8], RSinThSinPh[8], RSinThCosPh[8];
float SSinTh[8], SCosThSinPh[8], SCosThCosPh[8];
float TCosPh[8], TSinPh[8];
float x, y, z, xn, yn, zn;
int q;
float xscale, yscale, zscale, scale;
Byte Col;

void main()
{
  Init_Graphics(56);
  Init_Perspective(true, 0, 0, 400, 500);
  Init_Plotting(-135, 40);
  Put_Axis_And_Palette(true);
  Axis_And_Palette();
  scale=150.0;
  xscale=scale;
  yscale=scale;
  zscale=scale;
  x=0.0;
  y=0.0;
  z=0.0;
  for(q=0; q<8; q++)
  {
    RCosTh[q]=r[q]*CosD(th[q]);
    RSinThSinPh[q]=r[q]*SinD(th[q])*SinD(ph[q]);
    RSinThCosPh[q]=r[q]*SinD(th[q])*CosD(ph[q]);
    SSinTh[q]=s[q]*SinD(th[q]);
    SCosThSinPh[q]=s[q]*CosD(th[q])*SinD(ph[q]);
    SCosThCosPh[q]=s[q]*CosD(th[q])*SinD(ph[q]);
    TCosPh[q]=t[q]*CosD(ph[q]);
    TSinPh[q]=t[q]*SinD(ph[q]);
  }
  while(!(kbhit()))
  {
    q=random(7);
    xn=h[q]+x*RCosTh[q]-y*SSinTh[q];
    yn=k[q]+x*RSinThSinPh[q]+y*SCosThSinPh[q]+z*TCosPh[q];
    zn=l[q]+x*RSinThCosPh[q]+y*SCosThCosPh[q]-z*TSinPh[q];
    Col= q * 36 + 35;
    Cartesian_Plot_3D(xscale*xn, yscale*yn, zscale*zn, Col);
    x=xn;
    y=yn;
    z=zn;
  }
  Exit_Graphics();
}