/***********************************************************************\
 *                                PC2.c                                *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * PC2.h        Program Commander/2 header file.                       *
 *                                                                     *
\***********************************************************************/

#ifndef IPFC                            /* Don't include if we compile HLP files */
#define         INCL_WIN                /* Environment include files */
#define         INCL_GPI
#define         INCL_DOS
#define         INCL_DOSERRORS
#include        <os2.h>

#include        <stdio.h>               /* C Set/2 include files */
#include        <stdlib.h>
#include        <string.h>
#include        <ctype.h>
#include        <memory.h>
#endif

                                        /* WIN-OS2 3.1 settings defined only in 2.1 toolkit */
#define         PROG_31_STDSEAMLESSVDM      15
#define         PROG_31_STDSEAMLESSCOMMON   16
#define         PROG_31_ENHSEAMLESSVDM      17
#define         PROG_31_ENHSEAMLESSCOMMON   18
#define         PROG_31_ENH                 19
#define         PROG_31_STD                 20
                                        /* Define an additional session type of WPS object
                                           representing any object */
#define         SSF_TYPE_WPSOBJECT          21
#define         FAPPTYP_WINDOWSPROT31       0x1000

/*--------------------------------------------------------------------------------------*\
 *                                                                                      *
 * +-----+-----+-----+                                                                  *
 * | www |    www========== Some windows, only two seen by the user on the display.     *
 * | www |     |     |                                                                  *
 * +-----+-----www---+===== Virtual Desktop (9fold-size of physical Desktop).           *
 * |     | www wwww  |                                                                  *
 * |  +----www | ww  |                                                                  *
 * +--|ww  www-+-----+                                                                  *
 * |  |ww   |============== Physical Desktop somewhere within virtual Desktop. The      *
 * |  +-----+  |     |      physical Desktop is the part of the virtual Desktop which   *
 * +-----+-----+-----+      the user visually can see, therefor large parts of the      *
 *                          virtual Desktop can't be ssen by the user. He must use      *
 * his pointing device, the slide the physical Desktop around the virtual Desktop, by   *
 * moving the pointer over the surrounding rows and columns of the physical screen.     *
 *                                                                                      *
\*------------------------------------------------------------------------------------- */
                                        /* Status bits defined for bitmapped ulMoveFlag */
#define         MOVEXR          0x1     /* Set if we move all windows right (our physical
                                           Desktop will move left on the virtual Desktop) */
#define         MOVEXL          0x2     /* Set if we move all windows left */
#define         MOVEYU          0x4     /* Set if we move all windows up (our physical
                                           Desktop will move down on the virtual Desktop */
#define         MOVEYD          0x8     /* Set if we move all windows down */
#define         MOVED4CLICK     0x10    /* Set if we are to move all windows, but the
                                           CLICK2MOVE flag is set, and therefor we require
                                           a click before we really move */
                                        /* Status bits defined for bitmapped ulStatusFlag */
#define         SLIDINGFOCUS    0x1     /* Set if the user requested a sliding focus */
#define         VIRTUALDESKTOP  0x2     /* Set if the user requested a virtual Desktop */
#define         MOVEDESKTOP     0x4     /* Set if the user also wants the WPS to move */
#define         CLICK2MOVE      0x8     /* Set if the user wants to click before Desktop
                                           moves */
#define         OVERVIEW        0x10    /* Set if the user wants an overview window */
#define         PRESERVEZORDER  0x20    /* Set if sliding focus should preserve the Z-order of
                                           the windows */

#define         EF_SIZE60       60
#define         EF_SIZE255      255

typedef struct  _SESSIONDATA            SESSIONDATA;
typedef struct  _MENUDATA               MENUDATA;
typedef struct  _COMMANDLINEPARAMS      COMMANDLINEPARAMS;
typedef struct  _HOOKPARAMETERS         HOOKPARAMETERS;
typedef void    (EXPENTRY PFFUNCPTR1)(HOOKPARAMETERS *HookParameters);
typedef void    (EXPENTRY PFFUNCPTR2)(HOOKPARAMETERS *HookParameters);
typedef BOOL    (EXPENTRY PFFUNCPTR3)(HAB hab, PQMSG pqmsg, ULONG option);

#define         ENTRYSUBMENU    0
#define         ENTRYMENUITEM   1
#define         ENTRYEMPTY      2

struct _SESSIONDATA                     /* Control structure to start a new session */
{
ULONG           id;                     /* Session ID for menu ressources */
UCHAR           PgmTitle[EF_SIZE60+1];  /* Session title */
UCHAR           PgmName[EF_SIZE255+1];  /* Session path and filename */
                                        /* Session working directory */
UCHAR           PgmDirectory[EF_SIZE255+1];
                                        /* Session parameter */
UCHAR           PgmInputs[EF_SIZE255+1];
UCHAR           PgmDosSettings[2049];   /* DOS Settings for DOS sessions */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
};

struct _MENUDATA                        /* Control structure to build popup menu */
{
USHORT          Item;                   /* MENUITEM or SUBMENU */
HWND            hwndItem;               /* Window handle within Popup-Menu */
ULONG           id;                     /* Session ID for menu ressources */
PSZ             PgmTitle;               /* Session title */
PSZ             PgmName;                /* Session path and filename */
PSZ             PgmDirectory;           /* Session working directory */
PSZ             PgmInputs;              /* Session parameter */
PSZ             PgmDosSettings;         /* Session settings for DOS applications */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
MENUDATA        *Back;                  /* Pointer to previous menu */
MENUDATA        *Submenu;               /* Pointer to a submenu */
MENUDATA        *Next;                  /* Pointer to next menu */
};

struct  _COMMANDLINEPARAMS
{
UCHAR           ucPBefore[EF_SIZE60+1]; /* Parameters before user requested parameter */
UCHAR           ucPUser[128];           /* User requested parameter */
UCHAR           ucPAfter[EF_SIZE60+1];  /* Parameters after user requested parameter */
};

struct  _HOOKPARAMETERS
{
HAB             habWindow;              /* Anchor block handle of PC/2 */
HWND            hwndWPS;                /* WPS window handle where mouse clicks on WPS
                                           can be found */
HWND            hwndDesktop;            /* PM window handle where mouse clicks on Desktop
                                           can be found */
HWND            hwndPC2;                /* PC/2's window handle to send/post messages to */
UCHAR           ucDesktopName[20];      /* Name of Desktop, f.e. OS/2 2.0 Desktop */
ULONG           ulScrollPercentage;     /* Percentage of physical Desktop used to scroll
                                           through virtual Desktop (25, 50, 75, 100 %) */
ULONG           ulStatusFlag;           /* Bitmapped status flag */
ULONG           ulClickFlag;            /* WM_BUTTON1CLICK for a single click, and
                                           WM_BUTTON1DBLCLK for a double click */
POINTL          DesktopSize;            /* Size of the physical Desktop screen */
POINTL          VirtualDesktopPos;      /* Position of the physical Desktop within the virtual */
POINTL          VirtualDesktopMin;      /* Lower left position of whole virtual Desktop */
POINTL          VirtualDesktopMax;      /* Upper right position of whole virtual Desktop */
LONG            SlidingXFactor;         /* Sliding offset in pixel for horizontal movements */
LONG            SlidingYFactor;         /* Sliding offset in pixel for vertical movements */
};

#define ID_PC2MAINWINDOW        256
#define ID_PC2POPUPMENU         257

#define PC2_CLASSNAME           "PC2"

#define ID_PC2SETUP             300     /* Defines for PopUp Menu, that is popped up after
                                           the user presses mouse button 1 on DESKTOP */
#define ID_CONFIGDIALOG         301     /* User pressed Configure Menu */
#define ID_ABOUTDIALOG          302     /* User pressed About PC/2 */
#define ID_EXIT                 303     /* User pressed F3 to exit PC/2 */
#define ID_SHUTDOWN             304     /* User pressed ShutDown OS/2 */
#define ID_DESKTOPDIALOG        305     /* User pressed Configure Desktop */

#define PIID_PROGRAMDIALOG      500     /* Program installation dialog */
#define PIGRP_PROGRAM           501     /* Program data group */
#define PIEF_PROGRAMTITLE       502
#define PIEF_PATHFILENAME       503
#define PIEF_DIRECTORY          504
#define PIEF_PARAMETERS         505
#define PIEF_DOSSETTINGS        506
#define PIPB_WINFILEDLG         507

#define PIGRP_TYPE              510     /* Program type group */
#define PIRB_SHELL              511
#define PIRB_OS2FULLSCREEN      512
#define PIRB_OS2WINDOW          513
#define PIRB_PM                 514
#define PIRB_DOSFULLSCREEN      515
#define PIRB_DOSWINDOW          516
#define PIRB_WPSOBJECT          517
#define PIRB_WINOS2             518

#define PIGRP_STYLE             520     /* Program style group */
#define PIRB_DEFAULTSTYLE       521
#define PIRB_MAXIMIZED          522
#define PIRB_MINIMIZED          523
#define PIRB_SIZEPOSITION       524
#define PIRB_INVISIBLE          525
#define PIRB_NOAUTOCLOSE        526
#define PIRB_BACKGROUND         527

#define PIGRP_SIZEPOSITION      530     /* User defined size & position */
#define PIEF_X                  531
#define PIEF_Y                  532
#define PIEF_XSIZE              533
#define PIEF_YSIZE              534

#define PIGRP_WINOS2            540     /* Seamless WIN-OS2 settings */
#define PIRB_WINREAL            541
#define PIRB_WINSTANDARD        542
#define PIRB_WIN386ENHANCED     543
#define PICB_WINVDM             544
#define PIRB_SEAMLESSWINOS2     545
#define PIRB_FULLSCREENWINOS2   546

#define PIID_HELP_1             550     /* Help pages */
#define PIID_HELP_2             551
#define PIID_HELP_3             552
#define PIID_HELP_4             553
#define PIID_HELP_5             554

#define ADID_ABOUTDIALOG        600     /* About program dialog */

#define DDID_DESKTOPDIALOG      650     /* Desktop configuration dialog */
#define DDGRP_SLIDINGFOCUS      651
#define DDCB_SLIDINGFOCUS       652
#define DDCB_PRESERVEZORDER     653
#define DDGRP_VIRUTALDESKTOP    660
#define DDCB_VIRTUALDESKTOP     661
#define DDCB_MOVEDESKTOP        662
#define DDCB_CLICK2MOVE         663
#define DDCB_OVERVIEW           664
#define DDEF_DESKTOPNAME        665
#define DDLB_SCROLLPERCENTAGE   666

#define CDID_CONFIGDIALOG       700     /* Configuration menu dialog */
#define CDGRP_PROGRAM           701     /* Submenu/Program installation group */
#define CDLB_MENUPROGRAM        702
#define CDID_LEVELUP            703
#define CDID_LEVELDOWN          704
#define CDID_ADDMENU            705
#define CDID_ADDPROGRAM         706
#define CDID_CHANGEENTRY        707
#define CDID_REMOVEENTRY        708
#define CDID_RESORT             709

#define CDID_HELP_1             710     /* Help pages */
#define CDID_HELP_2             711

#define RDID_RESORTDIALOG       750     /* Resort menuentries dialog */
#define RDPB_MOVE               751     /* Move pushbutton */
#define RDGRP_SOURCEMENU        755     /* Move from menu */
#define RDLB_SOURCEMENU         756
#define RDGRP_DESTINATIONMENU   760     /* Move into menu */
#define RDLB_DESTINATIONMENU    761

#define MIID_MENUDIALOG         800     /* Menu installation dialog */
#define MIGRP_PROGRAM           801     /* Menu data group */
#define MIEF_MENUTITLE          802

#define MIID_HELP_1             810     /* Help page */

#define SDID_SHUTDOWNDIALOG     900     /* OS/2 ShutDown dialog */
#define SDID_SHUTDOWNMESSAGE    901     /* Message diaplayed a ShutDown */

#define SUID_STARTUPDIALOG      950     /* Request parameters from user before launching
                                           an application */
#define SUTF_STARTUPINFO        951     /* Info to the user what to do */
#define SUTF_STARTUPPARAMETERS  952     /* Info to the user of current parameters */
#define SUEF_STARTUPPARAMETERS  953     /* Entryfield for user data */

#define ID_POPUPMENU            1000    /* ID used by first user entered entry in the 
                                           popup menu. It is incremented by 1 by tracing
                                           through the linked list for each entry (submenu
                                           or menuitem). */
#define USERITEMFIRST           ID_POPUPMENU
#define USERITEMLAST            ID_POPUPMENU+200

#define ID_HELP                 2000    /* ID used for HELP panels */
#define MAIN_HELP_TABLE         2001
#define MAIN_HELP_SUBTABLE      2002
#define ID_GENERALHELP          2003
#define ID_CONCEPTSHELP         2004
#define ID_USINGHELP            2005
#define ID_ERRORHELP            2006
#define ID_ERRORHELP_1          2007
#define ID_INSTALLATIONHELP     2008

                                        /* New messages for the configuration menu dialog */
                                        /* Load the current level into configuration listbox */
#define WM_LOADPOPUPMENU        WM_USER+1
                                        /* Initialize the input queue hook */
#define WM_LOADHOOK             WM_USER+2
                                        /* Save Popup-Menu to Profile */
#define WM_SAVEPOPUPMENU        WM_USER+3
                                        /* Load Popup-Menu from Profile */
#define WM_SETPOPUPMENU         WM_USER+4
                                        /* Display Popup-Menu on Desktop */
#define WM_POPUPMENU            WM_USER+5

                                        /* Insert an item to the linked list */
#define MM_INSERTITEMMENUITEM   WM_USER+6
                                        /* Change the first item of a Submenu to an item */
#define MM_INSERTITEMSUBMENU    WM_USER+7
                                        /* Move an item of a Submenu to another position */
#define MM_MOVEMENUITEM         WM_USER+8
                                        /* ShutDown message to ShutDown dialog */
#define WM_SHUTDOWN             WM_USER+9
                                        /* Program Type configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMTYPE     WM_USER+10
                                        /* Program Priority configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMPRIORITY WM_USER+11
                                        /* Program Size & Position configuration of Program
                                           Installation dialog */
#define WM_SETUPSIZEPOSITION    WM_USER+12
                                        /* Query and set desktop window handle */
#define WM_SETDESKTOPHANDLE     WM_USER+13
                                        /* Sent by PC2HOOK.DLL if windows need to be moved */
#define WM_DESKTOPMOVE          WM_USER+14

                                        /* Procedures */
extern int      main(int argc, char *argv[], char *envp[]);
extern BOOL     WinStartUp(HAB *pHab, HMQ *pHmq);
extern BOOL     WinStartHelp(HAB hab, UCHAR *pHelpfile, HWND *pHwndHelp);
extern BOOL     WinCloseDown(HWND *pHwndHelp, HAB *pHab, HMQ *pHmq);
extern void     StartSession(SESSIONDATA *SessionData);
extern BOOL     LoadMenuData2SessionData(BOOL Empty, MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern BOOL     LoadSessionData2MenuData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern MENUDATA *AllocateMenuData(void);
extern void     LoadMenu(MENUDATA *pMenuData);
extern void     SaveMenu(MENUDATA *pMenuData);
extern MRESULT  SetPopupMenu(ULONG msg, MPARAM mp1, MPARAM mp2);
extern MENUDATA *SearchItem(MENUDATA *pMD, ULONG *id);
extern void     InstallFilename2Dialog(HWND hwndDlg, UCHAR *pucFullFileName, BOOL bObject);
extern void     DisableDialogItem(HWND hwndDlg, USHORT usDialogIDs[], USHORT usItemCount, ULONG ulStyle);
extern void     INIAccess(UCHAR *pucFilenameINI, BOOL bRead);

                                        /* Window procedures */
extern MRESULT  EXPENTRY PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY CD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY DD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

extern HAB              hab;            /* Handle of PM anchor block */
extern HMQ              hmq;            /* Handle of message queue */
extern HWND             hwndFrame;
extern HWND             hwndClient;
extern HWND             hwndPopupMenu;  /* Handel of popup menu window */
extern HWND             hwndHelp;
extern SESSIONDATA      SessionData;
extern HOOKPARAMETERS   HookParameters; /* Parameters passed to PC2HOOK.DLL */
extern MENUDATA         *pPopupMenu;    /* First entry of linked list of menus */
extern MENUDATA         *pMenuData;     /* First entry of current level of linked list */
extern USHORT           DialogResult;   /* Result of last dialog */
extern USHORT           MenuDataId;     /* Id of the items in the Popup-Menu and linked list */
extern FILE             *Pc2Profile;    /* Profile filename */
                                        /* Path of PC2.INI */
extern UCHAR            *pucFilenameINI;
extern SWP              swpScreen;      /* The screen dimensions */
                                        /* Pointer to DLL-Functions */
extern PFFUNCPTR1       *pPC2DLL_SetParameters;
extern PFFUNCPTR2       *pPC2DLL_QueryParameters;
extern PFFUNCPTR3       *pPC2DLL_Hook;


