/* Copyright (C) 1993-1996, Russell Lang.  All rights reserved.
  
  This file is part of GSview.
  
  This program is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the GSview Free Public Licence 
  (the "Licence") for full details.
  
  Every copy of GSview must include a copy of the Licence, normally in a 
  plain ASCII text file named LICENCE.  The Licence grants you the right 
  to copy, modify and redistribute GSview, but only under certain conditions 
  described in the Licence.  Among other things, the Licence requires that 
  the copyright notice and this notice be preserved on all copies.
*/

/* gvcrc.h */
/* Common Resource header file */

#include "gvcver.h"

#define PACKED			/* packing set by other means */

#define ID_GSVIEW 1
#define ID_GSVIEW2 2
#define ID_GSVIEW3 3
#define ID_GSVIEW_DOC	4

#define IDD_ABOUT 	50
#define IDD_INPUT 	51
#define ID_ANSWER	52
#define ID_PROMPT	53
#define ID_HELP		54
#define ID_DEFAULT	55

#define IDM_FILEMENU	100
#define IDM_OPEN	101
#define IDM_SELECT	102
#define IDM_SAVEAS	103
#define IDM_EXTRACT	104
#define IDM_PSTOEPS	105
#define IDM_CLOSE	106
#define IDM_CLOSE_DONE	107
#define IDM_INFO	108
#define IDM_PRINT	110
#define IDM_PRINTTOFILE 111
#define IDM_SPOOL	112
#define IDM_GSMESS      113
#define IDM_EXIT	114
#define IDM_DROP	115

#define IDM_EDITMENU	150
#define IDM_COPYCLIP	151
#define IDM_PASTETO	152
#define IDM_CONVERT	153
#define IDM_ADDEPSMENU	154
#define IDM_MAKEEPSI	155
#define IDM_MAKEEPST4	156
#define IDM_MAKEEPST	157
#define IDM_MAKEEPSW	158
#define IDM_MAKEEPSU	159
#define IDM_EXTEPSMENU	160
#define IDM_EXTRACTPS	161
#define IDM_EXTRACTPRE	162
#define IDM_TEXTEXTRACT	     163
#define IDM_TEXTEXTRACT_SLOW 164
#define IDM_TEXTFIND	     165
#define IDM_TEXTFINDNEXT     166

#define IDM_OPTIONMENU	  174
#define IDM_GSCOMMAND	  175
#define IDM_SOUNDS	  176
#define IDM_SETTINGS	  177
#define IDM_SAVESETTINGS  178
#define IDM_SAFER         179  
#define IDM_SAVEDIR	  180
#define IDM_BUTTONSHOW	  181
#define IDM_FITPAGE	  182
#define IDM_QUICK_OPEN	  183
#define IDM_QUICK_TEXT	  184
#define IDM_AUTOREDISPLAY 185
#define IDM_EPSFCLIP	  186
#define IDM_EPSFWARN	  187
#define IDM_IGNOREDSC	  188
#define IDM_SHOWBBOX      189

#define IDM_UNITMENU	190
#define IDM_UNITPT	191
#define IDM_UNITMM	192
#define IDM_UNITINCH	193

#define IDM_DRAWMENU	195	/* OS/2 only */
#define IDM_DRAWDEF	196
#define IDM_DRAWGPI	197
#define IDM_DRAWWIN	198

#define IDM_VIEWMENU    200
#define IDM_NEXT	201
#define IDM_NEXTHOME	202
#define IDM_NEXTSKIP	203
#define IDM_PREV	204
#define IDM_PREVHOME	205
#define IDM_PREVSKIP	206
#define IDM_GOTO	207
#define IDM_REDISPLAY   208
#define IDM_SKIP	209

#define IDM_ORIENTMENU	220
#define IDM_PORTRAIT	221
#define IDM_LANDSCAPE   222
#define IDM_UPSIDEDOWN  223
#define IDM_SEASCAPE	224
#define IDM_SWAPLANDSCAPE 225

#define IDM_DISPLAYSETTINGS	250
#define IDM_ZOOM	251
#define IDM_MAGPLUS	252
#define IDM_MAGMINUS	253

#define IDM_MEDIAMENU	300
#define IDM_LETTER	301
#define IDM_LETTERSMALL	302
#define IDM_TABLOID	303
#define IDM_LEDGER	304
#define IDM_LEGAL	305
#define IDM_STATEMENT	306
#define IDM_EXECUTIVE	307
#define IDM_A3		308
#define IDM_A4		309
#define IDM_A4SMALL	310
#define IDM_A5		311
#define IDM_B4		312
#define IDM_B5		313
#define IDM_FOLIO	314
#define IDM_QUARTO	315
#define IDM_10X14	316
#define IDM_USERSIZE	317
#define IDM_MEDIALAST	318

#define IDM_HELPMENU	350
#define IDM_HELPCONTENT 351
#define IDM_HELPSEARCH	352
#define IDM_HELPKEYS	353
#define IDM_ABOUT	354
#define IDM_MISC	355

/* info dialog box */
#define IDD_INFO	400
#define INFO_FILE	401
#define INFO_TYPE	402
#define INFO_TITLE	403
#define INFO_DATE	404
#define INFO_BBOX	405
#define INFO_ORIENT	406
#define INFO_ORDER	407
#define INFO_DEFMEDIA	408
#define INFO_NUMPAGES	409
#define INFO_PAGE	410
#define INFO_BITMAP	411
#define INFO_ICON	412

#define ABOUT_ICON	451
#define ABOUT_VERSION	452

#define IDD_SOUND	500
#define SOUND_EVENT	501
#define SOUND_FILE	502
#define SOUND_PATH	503
#define SOUND_TEST	504

#define IDD_SPOOL	514
#define SPOOL_PORT	515
#define SPOOL_PORTTEXT	516
#define SPOOL_TOFILE	517

#define CANCEL_PCDONE	521

#define IDD_PAGE	530
#define IDD_MULTIPAGE	531
#define PAGE_LIST	532
#define PAGE_LISTTEXT	533
#define PAGE_ALL	534
#define PAGE_ODD	535
#define PAGE_EVEN	536

#define IDD_DEVICE	540
#define DEVICE_NAME	541
#define DEVICE_RES	542
#define DEVICE_RESTEXT	543
#define DEVICE_PROP	544

#define IDD_PROP	550
#define PROP_NAME	551
#define PROP_VALUE	552
#define PROP_EDIT	553
#define PROP_NEW	554
#define PROP_XOFFSET	555
#define PROP_YOFFSET	556

#define IDD_EDITPROP	560
#define EDITPROP_STRING	561
#define EDITPROP_NUMBER	562
#define EDITPROP_NAME	563
#define EDITPROP_VALUE	564
#define NEWPROP_DEL	565
#define EDITPROP_DEL	566

#define IDD_TEXTWIN	570
#define TEXTWIN_MLE	571
#define TEXTWIN_COPY	572

#define IDD_BBOX	575
#define BB_PROMPT	576
#define BB_CLICK	577

#define IDD_INSTALL	580
#define INSTALL_DLL	581
#define INSTALL_INCLUDE	582
#define INSTALL_OTHER	583

#define IDD_DSET	590
#define DSET_RES	591
#define DSET_ZOOMRES	592
#define DSET_DEPTH	593
#define DSET_TALPHA	594
#define DSET_GALPHA	595
#define DSET_DRAWMETHOD	596


/* file filters */
#define FILTER_PSALL	0
#define FILTER_PS	1
#define FILTER_EPS	2
#define FILTER_EPI	3
#define FILTER_PDF	4
#define FILTER_ALL	5
#define FILTER_BMP	6
#define FILTER_TIFF	7
#define FILTER_WMF	8
#define FILTER_TXT	9

/* string constants */
#define IDS_FILTER	601
#define IDS_HELPFILE	603
#define IDS_FILENOTFOUND 606
#define IDS_PRINTBUSY	607

#define IDS_FILE	610
#define IDS_NOFILE	611
#define IDS_PAGE	612
#define IDS_NOPAGE	613
#define IDS_PAGESPECIAL	614
#define IDS_LANDSCAPE	615
#define IDS_PORTRAIT	616
#define IDS_ASCEND	617
#define IDS_DESCEND	618
#define IDS_SPECIAL	619
#define IDS_EPSF	620
#define IDS_EPSI	621
#define IDS_EPST	622
#define IDS_EPSW	623
#define IDS_DSC		624
#define IDS_NOTDSC	625
#define IDS_PDF         626
#define IDS_IGNOREDSC   627
#define IDS_PAGEINFO	628

#define IDS_OUTPUTFILE	630
#define IDS_PRINTINGALL	631
#define IDS_PRINTFILE	632
#define IDS_PRINTAGAIN	633
#define IDS_SELECTPAGE	635
#define IDS_SELECTPAGES	636
#define IDS_NOTOPEN	639
#define IDS_CANNOTRUN	640
#define IDS_TOOLONG	641
#define IDS_NOMORE	642
#define IDS_GSCOMMAND	643
#define IDS_NOZOOM	646
#define	IDS_USERWIDTH	647
#define	IDS_USERHEIGHT	648
#define IDS_BADEPS	649
#define IDS_NOPREVIEW	650
#define IDS_NOTDFNAME   651
#define IDS_NOTEMP	652
#define IDS_CANCELDONE	653
#define IDS_BADCLI      654
#define IDS_DUPOPT      655
#define IDS_TEXTFIND	656
#define IDS_TEXTNOTFIND	657

#define IDS_SOUNDNAME	670
#define IDS_SNDPAGE	671
#define IDS_SNDNOPAGE	672
#define IDS_SNDNONUMBER 673
#define IDS_SNDNOTOPEN	674
#define IDS_SNDERROR	675
#define IDS_SNDTIMEOUT	676
#define IDS_SNDSTART	677
#define IDS_SNDEXIT	678
#define IDS_SNDBUSY	679
#define IDS_SOUNDNOMM	680
#define IDS_NONE	681
#define IDS_SPKR	682

/* help topics */
#define IDS_TOPICROOT	701
#define IDS_TOPICOPEN	702
#define IDS_TOPICPRINT	703
#define IDS_TOPICPROP   704
#define IDS_TOPICEDITPROP 705
#define IDS_TOPICCLIP   706
#define IDS_TOPICPREVIEW 707
#define IDS_TOPICGSCMD	708
#define IDS_TOPICSOUND	709
#define IDS_TOPICDSET   710
#define IDS_TOPICMEDIA  711
#define IDS_TOPICPSTOEPS 712
#define	IDS_TOPICGOTO    713
#define IDS_TOPICINSTALL 714
#define IDS_TOPICTEXT    715
#define IDS_TOPICKEYS    716
#define IDS_TOPICMESS    717
#define IDS_TOPICSPOOL   718

/* ps_to_eps */
#define IDS_BBPROMPT	750
#define IDS_BBPROMPT1	751
#define IDS_BBPROMPT2	752
#define IDS_BBPROMPT3	753
#define IDS_EPSONEPAGE	754
#define IDS_EPSQPAGES	755
#define IDS_EPSNOBBOX	756
#define IDS_EPSREAD     757
#define IDS_EPSUSERINVALID 758
#define IDS_EPSUSERTITLE 759
#define IDS_EPS_OFF_PAGE 760

/* wait messages */
#define IDS_NOWAIT	0
#define IDS_WAIT	770
#define IDS_WAITREAD	771
#define IDS_WAITWRITE	772
#define IDS_WAITDRAW	773
#define IDS_WAITDRAW_PC	774
#define IDS_WAITGSOPEN	775
#define IDS_WAITGSCLOSE	776
#define IDS_WAITPRINT	777
#define IDS_WAITSEARCH	778
#define IDS_WAITTEXT  	779

/* debug messages */
#define IDS_DEBUG_DFISLOCKED   780
#define IDS_DEBUG_DFISOPEN     781
#define IDS_DEBUG_DFISMISSING  782
#define IDS_DEBUG_DFCHANGED    783
#define IDS_DEBUG_DFISCLOSED   784

/* process delayed messages */
#define IDS_PROCESS_GSLOAD_FAIL  785
#define IDS_PROCESS_INIT_FAIL    786
#define IDS_PROCESS_VIEWER_FAIL  787
#define IDS_PROCESS_EXECUTE_FAIL 788

/* PDF messages */
#define IDS_PDFNOPAGE		790
#define IDS_PDFEXTRACTALL	791

/* filter strings */
#define IDS_FILTER_BASE	800
#define IDS_FILTER_PSALL IDS_FILTER_BASE+FILTER_PSALL
#define IDS_FILTER_PS	IDS_FILTER_BASE+FILTER_PS
#define IDS_FILTER_EPS	IDS_FILTER_BASE+FILTER_EPS
#define IDS_FILTER_EPI	IDS_FILTER_BASE+FILTER_EPI
#define IDS_FILTER_PDF	IDS_FILTER_BASE+FILTER_PDF
#define IDS_FILTER_ALL	IDS_FILTER_BASE+FILTER_ALL
#define IDS_FILTER_BMP	IDS_FILTER_BASE+FILTER_BMP
#define IDS_FILTER_TIFF	IDS_FILTER_BASE+FILTER_TIFF
#define IDS_FILTER_WMF	IDS_FILTER_BASE+FILTER_WMF
#define IDS_FILTER_TXT	IDS_FILTER_BASE+FILTER_TXT


/* RCDATA resources */
#define IDR_VIEWER	902
#define IDR_EPSFWARN	903
#define IDR_DEVICES	904
#define IDR_PORTS	905
#define IDR_BUTTON	906

/* cursors */
#define IDP_CROSSHAIR  910

/* window messages */

#define WM_GSV16SPL    WM_USER+1	/* 16 bit spooler interface */
#define WM_GSWAIT      WM_USER+2	/* info_wait from dll thread */
#define WM_GSMESSBOX   WM_USER+3	/* delayed message box */
#define WM_GSSHOWMESS  WM_USER+4	/* delayed show messages */
#define WM_GSREDISPLAY WM_USER+5	/* document changed during display */
#define WM_GSTITLE     WM_USER+6	/* change window title */
#define WM_GSPERCENT   WM_USER+7	/* percent processed for status line */
#define WM_GSTEXTINDEX WM_USER+8	/* load text index */

/* messages for Ghostscript events */	/* needs gsdll.h */
#define WM_GSDEVICE    WM_USER+10+GSDLL_DEVICE
#define WM_GSSYNC      WM_USER+10+GSDLL_SYNC
#define WM_GSPAGE      WM_USER+10+GSDLL_PAGE
#define WM_GSSIZE      WM_USER+10+GSDLL_SIZE

/* non standard scroll bar code */
#define SB_FIND WM_USER
