//========================================================================
//  DKDLL.C - The Subclass DLL for DKick
//  (c) Douglas Boling 1995
//
//  For better readability, set tab stops to every 3 characters.
//========================================================================
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "dkdll.h"
#include "dkick.h"
//
// Function prototypes
//
LONG CALLBACK DeskSCProc (HWND, UINT, UINT, LONG);
LONG CALLBACK ProgManSCProc (HWND, UINT, UINT, LONG);
LONG CALLBACK MDIClientSCProc (HWND, UINT, UINT, LONG);
WNDPROC MySubClassWindow (HWND, WNDPROC);

void SetHook (BOOL);

HANDLE	hInst;
WNDPROC	lpfnOldDeskWndProc = 0;               // Subclass pointer

int		sFlags = 0;
UINT		wBMess = WM_RBUTTONDOWN;

int      sNumKickListProgs;
char		szKickListPrograms[MAXENTRIES][MAXMENULEN];

HMENU		hMenu = 0;
HWND		hwndMyWin;
BOOL		fChkCmd = FALSE;
//=======================================================================
// Library initialization and terminataion functions
//=======================================================================
//------------------------------------------------------------------------
// LibMain - DLL initialization routine
//------------------------------------------------------------------------
int CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
	                   LPSTR lpszCmdLine) {
	hInst = hInstance;
	sNumKickListProgs = 0;
	fChkCmd = FALSE;

	SetHook (TRUE);
	return 1;
}
//------------------------------------------------------------------------
// WEP - DLL termination routine
//------------------------------------------------------------------------
int CALLBACK WEP (int nParameter) {
   
   if (hMenu) {
      DestroyMenu (hMenu);
   }   
	SetHook (FALSE);
	return 1;
}
//===================================================================
// Local procedures
//===================================================================
//-------------------------------------------------------------------
// SetHook - Enables the desktop window subclass
//-------------------------------------------------------------------
void SetHook (BOOL bEnable) {
	
	if (bEnable) {
		if (lpfnOldDeskWndProc == 0) {
			lpfnOldDeskWndProc = MySubClassWindow (GetDesktopWindow(),
			                        (WNDPROC)GetProcAddress (hInst, "DeskSCProc"));
		}
	} else {
		if (lpfnOldDeskWndProc) {
			MySubClassWindow (GetDesktopWindow(), lpfnOldDeskWndProc);
			lpfnOldDeskWndProc = 0;
		}
	}
	return;
}
//============================================================
// Desktop window subclass procedure
//============================================================
LONG CALLBACK DeskSCProc (HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	HMENU hProgMenu;
	int i;

	//
	//Check for mouse button down
	//
	if (wMsg == wBMess) {
		if (((sFlags & SFT_CTRL) && !(wParam & MK_CONTROL)) ||
		    ((sFlags & SFT_SHIFT) && !(wParam & MK_SHIFT))) 
			return CallWindowProc ((FARPROC)lpfnOldDeskWndProc, hWnd, 
			                       wMsg, wParam, lParam);

		if ((hMenu = CreatePopupMenu())) {

			for (i = 0; i < sNumKickListProgs; i++) 
			   AppendMenu (hMenu, MF_ENABLED, 0x7000 + i, 
			               (LPSTR) szKickListPrograms[i]);
				
			if (sNumKickListProgs)
				hProgMenu = CreatePopupMenu();
			else
				hProgMenu = hMenu;

		   AppendMenu (hProgMenu, MF_ENABLED,
  	            0x7ffe, (LPSTR) "Configure DropKick...");
		   AppendMenu (hProgMenu, MF_ENABLED,
  	            0x7fff, (LPSTR) "About DropKick...");
				   
			if (sNumKickListProgs) {
			   AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
			   AppendMenu (hMenu, MF_POPUP, (UINT)hProgMenu, (LPSTR) "DropKick");
			}
			fChkCmd = TRUE;
			TrackPopupMenu (hMenu, 0, LOWORD(lParam)-10, 
			                HIWORD (lParam)-5, 0, hWnd, 0);
	      DestroyMenu (hMenu);
	      hMenu = 0;
			return 0;
		} 
	} else if (fChkCmd && (wMsg == WM_COMMAND)) {
		if (hwndMyWin) {
			if ((wParam >= 0x7000)  && (wParam < 0x7000 + sNumKickListProgs))
				PostMessage (hwndMyWin, MYMSG_LAUNCHPROG, wParam - 0x7000, 0);
			
			else if (wParam == 0x7ffe) {
				ShowWindow (hwndMyWin, SW_RESTORE);
				SetFocus (hwndMyWin);
			} else if (wParam == 0x7fff)
				PostMessage (hwndMyWin, WM_COMMAND, IDD_ABOUT, 0);
		}
		fChkCmd = FALSE;
	}	
	return CallWindowProc ((FARPROC)lpfnOldDeskWndProc, hWnd, wMsg, wParam, lParam);
}
//===================================================================
// Library exported functions
//===================================================================
//-------------------------------------------------------------------
// GetStatus - Returns Status information
//-------------------------------------------------------------------
UINT CALLBACK GetStatus (void) {

	return sFlags;
}
//-------------------------------------------------------------------
// SetStatus - Returns Status information
//-------------------------------------------------------------------
VOID CALLBACK SetStatus (HWND hwndParent, UINT fFlags) {

	hwndMyWin = hwndParent;
	sFlags = fFlags;
	if ((sFlags & 0x0003) == 0)
	   wBMess = WM_LBUTTONDOWN;
	if ((sFlags & 0x0003) == 1)
	   wBMess = WM_MBUTTONDOWN;
	if ((sFlags & 0x0003) == 2)
	   wBMess = WM_RBUTTONDOWN;
 	return;
}
//-------------------------------------------------------------------
// GetKickList - Returns the name in launch list
//-------------------------------------------------------------------
VOID CALLBACK GetKickList (int sIndex, LPSTR lpszKickListName) {

	if (sIndex < sNumKickListProgs) {
	   lstrcpy (lpszKickListName, szKickListPrograms[sIndex]);
	}   
	return;
}
//-------------------------------------------------------------------
// SetKickList - Adds program name to launch list
//-------------------------------------------------------------------
VOID CALLBACK SetKickList (LPSTR lpszKickListName) {
	BOOL bFound = FALSE;
	int i;
	
   for (i = 0; i < sNumKickListProgs; i++) {
      if (lstrcmp (lpszKickListName, (LPSTR) szKickListPrograms[i]) == 0) {
         bFound = TRUE;
         break;
      }
   }
	if ((sNumKickListProgs < MAXENTRIES - 1) && (!bFound)) {
	   lstrcpy (szKickListPrograms[sNumKickListProgs++], lpszKickListName);
	}
	return;
}	
//-------------------------------------------------------------------
// RemoveKickList - Removes a program name from the launch list
//-------------------------------------------------------------------
VOID CALLBACK RemoveKickList (LPSTR lpszKickListName) {
	int	i, j;

   if (lpszKickListName == 0) {
	   sNumKickListProgs = 0;
		return;
	}
   for (i = 0; i < sNumKickListProgs; i++) {
      if (lstrcmp (lpszKickListName, (LPSTR) szKickListPrograms[i]) == 0) {
			for (j = i; j < sNumKickListProgs - 1; j++) 
			   strcpy (szKickListPrograms[j], szKickListPrograms[j+1]);
         break;
      }
   }
   sNumKickListProgs--;
	return;
}
//============================================================
// General helper routines
//============================================================
//------------------------------------------------------------
// MySubClassWindow - Subclasses a window 
//------------------------------------------------------------
WNDPROC MySubClassWindow (HWND hWnd, WNDPROC lpfnNewProc) {
   WNDPROC lpfnOldProc;

	lpfnOldProc = (WNDPROC) GetWindowLong (hWnd, GWL_WNDPROC);
	SetWindowLong (hWnd, GWL_WNDPROC, (LONG) lpfnNewProc);
	return lpfnOldProc;				               
}				               
