//===========================================================
// PLIDLL.H -- Header File 
// Copyright (c) 1995 Douglas Boling
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {
    UINT Code;
    LONG (*Fxn)(HWND, UINT, HWND, UINT);
};
struct decodeCPI {
    UINT Code;
    LONG (*Fxn)(HWND, UINT, LPARAM, LPARAM);
};
//
// Function prototypes used by generic template
//
INT  CALLBACK LibMain(HANDLE, WORD, WORD, LPSTR);
INT  CALLBACK WEP(INT);

LONG CALLBACK CPlApplet(HWND, UINT, LPARAM, LPARAM);
BOOL CALLBACK ConfigDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);

BOOL CALLBACK ShowAboutDialog (HWND);
UINT CALLBACK GetSetDLLFlags (UINT, UINT);
void CALLBACK ComputeNextIPos (HWND, LPPOINT);

INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
//
#define     MYMSG_RESETIPOS  WM_USER+20 

#define     MAXHANDLES       128
//
#define     STAT_TOP       0
#define     STAT_BOTTOM    1
#define     STAT_LEFT      2
#define     STAT_RIGHT     3
#define     STAT_HOOKED    8
#define     STAT_INSTALLED 0x10

#define     CTL_HOOK       1
#define     CTL_SIDES      2
#define     CTL_IFLAG      4
#define     CTL_HANDLE     8
//
// Profile String Names
//
#define     PRO_XPOS       "WinPosX"
#define     PRO_YPOS       "WinPosY"
#define     PRO_FLAGS      "Flags"
//
// Resource Idendifiers.  
//
#define     IDD_TOP        100
#define     IDD_BOTTOM     101
#define     IDD_LEFT       102
#define     IDD_RIGHT      103
#define     IDD_ABOUT      104
#define     IDD_INSTALL    105
#define     IDD_ENABLE     106

#define     IDD_STATUS     201
#define     IDD_QUESTION   202
#define     IDD_EXIT       203
