//===========================================================
// PLIDLL - A Control panel applet DLL
// Copyright (c) 1995 Douglas Boling
//===========================================================

//-----------------------------------------------------------
// Include files
//-----------------------------------------------------------
#include "windows.h"
#include "cpl.h"

#include "stdlib.h"
#include "string.h"

#include "plidll.h"

// Control Panel Extension message handler functions.
LONG DoCPlInit (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlGetCount (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlNewInquire (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlSelect (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlDblClk (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlStop (HWND, UINT, LPARAM, LPARAM);
LONG DoCPlExit (HWND, UINT, LPARAM, LPARAM);

// Config Dialog box functions
LONG DoInitDialogConfig (HWND, UINT, UINT, LONG);
LONG DoDestroyConfig (HWND, UINT, UINT, LONG);
LONG DoCommandConfig (HWND, UINT, UINT, LONG);

LONG DoConfigCtlPosition (HWND, UINT, HWND, UINT);
LONG DoConfigCtlEnable (HWND, UINT, HWND, UINT);
LONG DoConfigCtlInstall (HWND, UINT, HWND, UINT);
LONG DoConfigCtlAbout (HWND, UINT, HWND, UINT);
LONG DoConfigCtlExit (HWND, UINT, HWND, UINT);
LONG DoConfigCtlCancel (HWND, UINT, HWND, UINT);

// Utility function prototpes
INT InitDLL(HANDLE);
INT TermDLL(HANDLE, INT);

void SetButtons (HWND);
INT PILibHookInit (void);
INT PILibCPLTerm (void);
INT PILibHookTerm (void);
INT PILibHookCtl (UINT, UINT);
UINT PILibHookStat (void);
//------------------------------------------------------------
// Message dispatch table for CPIApplet
//------------------------------------------------------------
struct decodeCPI CPIMessages[] = {
	CPL_INIT, DoCPlInit,
	CPL_GETCOUNT, DoCPlGetCount,
	CPL_NEWINQUIRE, DoCPlNewInquire,
	CPL_SELECT, DoCPlSelect,
	CPL_DBLCLK, DoCPlDblClk,
	CPL_STOP, DoCPlStop,
	CPL_EXIT, DoCPlExit,
};
//------------------------------------------------------------
// Message dispatch tables for ConfigDlgProc
//------------------------------------------------------------
struct decodeUINT ConfigMessages[] = {
	WM_INITDIALOG, DoInitDialogConfig,
	WM_DESTROY, DoDestroyConfig,
	WM_COMMAND, DoCommandConfig,
};
struct decodeCMD ConfigCtlItems[] = {
	IDD_TOP, DoConfigCtlPosition,
	IDD_BOTTOM, DoConfigCtlPosition,
	IDD_LEFT, DoConfigCtlPosition,
	IDD_RIGHT, DoConfigCtlPosition,
	IDD_ENABLE, DoConfigCtlEnable,
	IDD_INSTALL, DoConfigCtlInstall,
	IDD_ABOUT, DoConfigCtlAbout,
	IDOK, DoConfigCtlExit,
	IDCANCEL, DoConfigCtlCancel
};

//-----------------------------------------------------------
// Global data for control panel applet.
//-----------------------------------------------------------
char szProfileName[] = "control.ini";
char szProSec[] = "Place Icons";  
HANDLE	hInst;
INT xPos, yPos;

char szTemp[256];
char szDLLName[128] = "PLIDLL.DLL";        // DLL file name
char szEXEName[128] = "PLICON.EXE";
HWND hEXEWnd = 0;
HINSTANCE hEXEInst = 0;

//============================================================
// DLL External Entry points and support routines
//============================================================
//============================================================
// LibMain -- Entry point called during DLL init
//============================================================
INT CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, 
                      WORD wHeapSize, LPSTR lpszCmdLine) {
	hInst = hInstance;

	if (InitDLL (hInstance))
		return 0;
	else
		return 1;
}
//============================================================
// WEP - DLL termination routine
//============================================================
INT CALLBACK WEP (INT nParameter) {
   
	TermDLL(hInst, 0);
	return 1;
}
//-----------------------------------------------------------
// InitDLL - Global initialization code for this application.
//-----------------------------------------------------------
INT InitDLL(HANDLE hInstance) {
	//Init hook stuff
	PILibHookInit ();
	//Get data from last invocation
	xPos = GetPrivateProfileInt (szProSec, PRO_XPOS, 100, 
	                             szProfileName);
	yPos = GetPrivateProfileInt (szProSec, PRO_YPOS, 100, 
	                             szProfileName);
	return 0;
}
//------------------------------------------------------------
// TermDLL - Instance termination code for this DLL.
//------------------------------------------------------------
INT TermDLL (HANDLE hinstance, int sDefRC) {
	
	MyWritePrivateProfileInt (szProSec, PRO_XPOS, xPos,
	                          szProfileName);
	MyWritePrivateProfileInt (szProSec, PRO_YPOS, yPos,
	                          szProfileName);
	//Clean up hook stuff.
	PILibHookTerm ();
	
	return sDefRC;
}
//============================================================
// CPlApplet - Entry point called by Control Panel
//============================================================
LONG CALLBACK CPlApplet (HWND hWnd, UINT wMsg, LONG lParam1,
                         LPARAM lParam2) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	for(i = 0; i < dim(CPIMessages); i++) {
		if(wMsg == CPIMessages[i].Code)
			return (*CPIMessages[i].Fxn)(hWnd, wMsg, lParam1, lParam2);
	}
	return 0;
}
//============================================================
// Message handling procedures for CPIApplet
//============================================================
//------------------------------------------------------------
// DoCPlInit - Notification that the extension is being
// loaded by the Control Panel 
//------------------------------------------------------------
LONG DoCPlInit (HWND hWnd, UINT wMsg, LPARAM lParam1, LPARAM lParam2) {
	if (hEXEWnd == 0)
		PILibHookInit ();
   return 1;
}
//------------------------------------------------------------
// DoCPlGetCount - Control Panel message querring the number
// of Applets in this DLL.
//------------------------------------------------------------
LONG DoCPlGetCount (HWND hWnd, UINT wMsg, LPARAM lParam1, 
                    LPARAM lParam2) {
   return 1;
}
//------------------------------------------------------------
// DoCPlNewInquire - Control Panel message querring information
// on a specific applet.
//------------------------------------------------------------
LONG DoCPlNewInquire (HWND hWnd, UINT wMsg, LPARAM lParam1, 
                      LPARAM lParam2) {
	LPNEWCPLINFO lpInfo;

	lpInfo = (LPNEWCPLINFO) lParam2;
	//Zero structure 
	_fmemset (lpInfo, 0, sizeof (NEWCPLINFO));
	
	lpInfo->dwSize = sizeof (NEWCPLINFO);
	lpInfo->hIcon = LoadIcon (hInst, "PLIcon");
	lstrcpy (lpInfo->szName, "Place Icons");
	lstrcpy (lpInfo->szInfo, "Control the placment of icons on the desktop");
   return 0;
}
//------------------------------------------------------------
// DoCPlSelect - Control Panel message that indicates the user
// has selected the icon of the applet.
//------------------------------------------------------------
LONG DoCPlSelect (HWND hWnd, UINT wMsg, LPARAM lParam1,
                  LPARAM lParam2) {
	return 0;
}
//------------------------------------------------------------
// DoCPlDblClk - Control Panel message that indicates the user
// has double clicked on the icon of the applet.
//------------------------------------------------------------
LONG DoCPlDblClk (HWND hWnd, UINT wMsg, LPARAM lParam1,
                  LPARAM lParam2) {

	MyDisplayDialog(hInst, "ConfigBox", hWnd, 
	                (WNDPROC) ConfigDlgProc, 0L);
	return 0;
}
//------------------------------------------------------------
// DoCPlStop - Control Panel message that indicating the
// applet is about to be unloaded.
//------------------------------------------------------------
LONG DoCPlStop (HWND hWnd, UINT wMsg, LPARAM lParam1, LPARAM lParam2) {
	return 0;
}
//------------------------------------------------------------
// DoCPlExit - Control Panel message that indicating the
// DLL is about to be unloaded.
//------------------------------------------------------------
LONG DoCPlExit (HWND hWnd, UINT wMsg, LPARAM lParam1, LPARAM lParam2) {

	PILibCPLTerm ();
	return 0;
}
//============================================================
// AboutDlgProc - About dialog box dialog procedure
//============================================================
BOOL CALLBACK AboutDlgProc (HWND hWnd, UINT wMsg, UINT wParam, 
                            LONG lParam) {
                              
	if((wMsg == WM_COMMAND) && ((wParam == IDOK) || 
	                            (wParam == IDCANCEL))) {
		EndDialog(hWnd, 0);
		return TRUE;
	} 
	return FALSE;
}
//============================================================
// ConfigDlgProc - Config dialog box dialog procedure
//============================================================
BOOL CALLBACK ConfigDlgProc(HWND hWnd, UINT wMsg, UINT wParam, 
                           LONG lParam) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	for(i = 0; i < dim(ConfigMessages); i++) {
		if(wMsg == ConfigMessages[i].Code)
			return (BOOL) (*ConfigMessages[i].Fxn)(hWnd, wMsg, 
			                                wParam, lParam);
	}
	return FALSE;
}
//============================================================
// Message handling procedures for ConfigDialog
//============================================================
//------------------------------------------------------------
// DoInitDlgConfig - process WM_INITDIALOG message for Config
// dialog box.
//------------------------------------------------------------ 
LONG DoInitDialogConfig (HWND hWnd, UINT wMsg, UINT wParam, 
                         LONG lParam) {

	SetButtons(hWnd);
	return TRUE;
}   
//------------------------------------------------------------
// DoDestroyConfig - process WM_DESTROY message for Config dialog
//------------------------------------------------------------ 
LONG DoDestroyConfig (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
   RECT	rect;

	//Save Window position
	if	(!IsIconic (hWnd)) {
		GetWindowRect (hWnd, &rect);
		xPos = rect.left;
		yPos = rect.top;
	}
	return FALSE;
}
//------------------------------------------------------------
// DoCommandConfig - process WM_COMMAND message for Config dialog
// by decoding the control IDs with the CtlItems[] array, 
// then Searching the corresponding function to process the command.
//------------------------------------------------------------ 
LONG DoCommandConfig (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	UINT	idItem, wNotifyCode;
	HWND	hwndCtl;

	idItem = (UINT) wParam;                      // Parse Parameters
	hwndCtl = (HWND) LOWORD(lParam);
	wNotifyCode = (UINT) HIWORD(lParam);
	//
	// Call routine to handle control message
	//
	for(i = 0; i < dim(ConfigCtlItems); i++) {
		if(idItem == ConfigCtlItems[i].Code)
			return (*ConfigCtlItems[i].Fxn)(hWnd, idItem, 
			                             hwndCtl, wNotifyCode);
	}
	return FALSE;
}
//------------------------------------------------------------
// DoConfigCtlPosition - Process Position radio buttons
//------------------------------------------------------------ 
LONG DoConfigCtlPosition (HWND hWnd, UINT idItem, HWND hwndCtl, 
                          UINT wNotifyCode) {
	UINT fFlags, usNewPos;
	
	if (wNotifyCode != BN_CLICKED)
		return 0;
		
	fFlags = PILibHookStat ();
	usNewPos = idItem - IDD_TOP;
	if ((fFlags & 0x0007) != usNewPos)
		PILibHookCtl (usNewPos, CTL_SIDES);
	return 0;
}
//------------------------------------------------------------
// DoConfigCtlEnable - Process Enable/Disable button
//------------------------------------------------------------ 
LONG DoConfigCtlEnable (HWND hWnd, UINT idItem, HWND hwndCtl, 
                        UINT wNotifyCode) {
	UINT fFlags;
	
	fFlags = PILibHookStat ();
	if (fFlags & STAT_HOOKED)
		fFlags &= ~STAT_HOOKED;
	else
		fFlags |= STAT_HOOKED;
		
	PILibHookCtl (fFlags, CTL_HOOK | CTL_SIDES);
	SetButtons(hWnd);
	return 0;
}
//------------------------------------------------------------
// DoConfigCtlInstall - Process Install/Uninstall button
//------------------------------------------------------------ 
LONG DoConfigCtlInstall (HWND hWnd, UINT idItem, HWND hwndCtl, 
                         UINT wNotifyCode) {
	UINT fFlags;
	INT rc;
	
	fFlags = PILibHookStat ();
	if (fFlags & STAT_INSTALLED) {
		rc = MessageBox (NULL, "Are you sure you want to remove PLICON "\
		                 "from your system?", "Place Icons", MB_YESNO);
		if (rc != IDYES)
			return 0;
		fFlags &= ~(STAT_INSTALLED | STAT_HOOKED);
	} else
		fFlags |= STAT_INSTALLED;

	PILibHookCtl(fFlags, CTL_IFLAG | CTL_HOOK | CTL_SIDES);
	SetButtons(hWnd);
	return 0;
}
//------------------------------------------------------------
// DoConfigCtlAbout - Process About button
//------------------------------------------------------------ 
LONG DoConfigCtlAbout (HWND hWnd, UINT idItem, HWND hwndCtl, 
                       UINT wNotifyCode) {
								
	MyDisplayDialog(hInst, "AboutBox", hWnd, 
   	             (WNDPROC) AboutDlgProc, 0);
	return 0;
}
//------------------------------------------------------------
// DoConfigCtlExit - Process Exit button
//------------------------------------------------------------ 
LONG DoConfigCtlExit (HWND hWnd, UINT idItem, HWND hwndCtl, 
                      UINT wNotifyCode) {
								
	EndDialog (hWnd, 0);
	return 0;
}
//------------------------------------------------------------
// DoConfigCtlCancel - Process Cancel button
//------------------------------------------------------------ 
LONG DoConfigCtlCancel (HWND hWnd, UINT idItem, HWND hwndCtl, 
                      UINT wNotifyCode) {
								
	EndDialog (hWnd, 0);
	return 0;
}
//------------------------------------------------------------
// SetButtons - Sets the proper state for the buttons.
//------------------------------------------------------------ 
void SetButtons (HWND hWnd) {
	UINT fFlags;
	
	fFlags = PILibHookStat ();
	
	CheckRadioButton (hWnd, IDD_TOP, IDD_RIGHT, 
	                  IDD_TOP + (fFlags & 0x0007));
	if (fFlags & STAT_HOOKED)
		SetDlgItemText (hWnd, IDD_ENABLE, "&Disable");
	else
		SetDlgItemText (hWnd, IDD_ENABLE, "&Enable");

	if (fFlags & STAT_INSTALLED) {
		SetDlgItemText (hWnd, IDD_INSTALL, "&Uninstall");
		EnableWindow (GetDlgItem (hWnd, IDD_ENABLE), TRUE);
	} else {
		SetDlgItemText (hWnd, IDD_INSTALL, "&Install");
		EnableWindow (GetDlgItem (hWnd, IDD_ENABLE), FALSE);
	}
	return;
}	
//============================================================
//============================================================
// End of Control Panel app.  Start of Control Icon placment 
// code.
//============================================================
//============================================================

INT InstallProgram (HINSTANCE);
INT UninstallProgram (HINSTANCE);
void ComputeIconPos (HWND, LPPOINT);
void ArrangeIcons (void);
LONG CALLBACK TaskSCProc (HWND, UINT, UINT, LONG);

HHOOK hShellHook = 0;                        // Hook handles
HHOOK hCallHook = 0;
FARPROC	lpfnOldTaskWndProc;                 // Subclass pointer

INT sCxDesk, sCyDesk, sCxIcon, sCyIcon, sCxISpacing, sCyISpacing;
UINT fStatFlags = -1;
//========================================================================
// Call Window Hook function - Monitors for windows changing to icons.
// This is accomplished by checking for WM_WINDOWPOSCHANGING messages,
// seeing if the window is being minimized and that the default icon
// position is -2, -2.  If so, a new position is computed and subbed 
// into the target position field.
//========================================================================
// Structure of info passed by the Message hook
typedef struct {
	LPARAM lParam;
	WPARAM wParam;
	UINT msg;
	HWND hWnd;
} MYMHSTRUCT;
typedef MYMHSTRUCT far *LPMYMHSTRUCT;

VOID FAR PASCAL MsgHookProc (int code, WORD wParam, LONG lParam) {
	LPMYMHSTRUCT lpms;
	LPWINDOWPOS lpwp;
 
	if (code >= 0) { 
		lpms = (LPMYMHSTRUCT) lParam;
		if (lpms->msg == WM_WINDOWPOSCHANGING) {
			lpwp = (LPWINDOWPOS) lpms->lParam;
			if (!IsWindow(lpwp->hwnd))  
				return;
			if (!(lpwp->flags & SWP_NOSIZE) && IsIconic (lpwp->hwnd) && 
			    (lpwp->x == -2) && (lpwp->y == -2)) {
				ComputeIconPos (lpwp->hwnd, (LPPOINT)&lpwp->x);
			}
		}
	}
	CallNextHookEx (hCallHook, code, wParam, lParam);
	return;
}
//========================================================================
// Shell Hook function - Monitors for windows being created.  When a 
// window is created, a message is posted to the caretaker app that 
// is always running when this DLL is loaded.  The app then mods the
// default icon position to -2, -2 so that it can be detected when the
// user minimizes it.
//========================================================================
VOID FAR PASCAL ShellHookProc (INT code, WORD wParam, LONG lParam) {
	static char szTest[128];
 
	if (code >= 0) { 
		if (code == HSHELL_WINDOWCREATED) {
			GetWindowText ((HWND) wParam, szTest, sizeof (szTest));
			if (stricmp (szTest, "Task List") == 0)
				lpfnOldTaskWndProc = MySubClassWindow ((HWND) wParam, 
				                           GetProcAddress (hInst, "TaskSCProc"));
			else if (hEXEWnd) 
					PostMessage (hEXEWnd, MYMSG_RESETIPOS, wParam, 0);

		} else if (code == HSHELL_WINDOWDESTROYED) {
			// Remove handle from icon pos array
			ComputeIconPos ((HWND) wParam, 0);
		}	
	}
	CallNextHookEx (hShellHook, code, wParam, lParam);
	return;
}
//============================================================
// Task Manager window subclass procedure
//============================================================
LONG CALLBACK TaskSCProc (HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {

	// If the Arrange Icons button is clicked, redirect message.
	if ((wMsg == WM_COMMAND) && (wParam == 104)) {
		ArrangeIcons ();         // Arrange the icons in our way.
		return 0;
	}
	return CallWindowProc (lpfnOldTaskWndProc, hWnd, wMsg,
	                       wParam, lParam);
}
//============================================================
// ShowAboutDialog - Exported routine that displays the PLICON
// about box.
//============================================================
BOOL CALLBACK ShowAboutDialog (HWND hWnd) {
	MyDisplayDialog(hInst, "AboutBox", hWnd, 
   	             (WNDPROC) AboutDlgProc, 0);
	return TRUE;
}	
//============================================================
// GetSetDLLFlags - Exported routine that Gets and Sets DLL 
// status flags.
//============================================================
UINT CALLBACK GetSetDLLFlags (UINT fNewFlags, UINT fSetFlags) {
	UINT fFlags;

	if (fSetFlags == CTL_HANDLE)
		hEXEWnd = fNewFlags;
	else if (fSetFlags) {
		fFlags = PILibHookCtl (fNewFlags, fSetFlags);
	}		
	return PILibHookStat ();
}	
//============================================================		
// ComputeNextIPos - Exported routine that returns the next
// free icon position.
//============================================================
void CALLBACK ComputeNextIPos (HWND hWnd, LPPOINT pt) {
	
	ComputeIconPos (hWnd, pt);
	return;	
}	
//-----------------------------------------------------------
// PILibHookInit - Init vars for system message hook
//-----------------------------------------------------------
WORD FAR PASCAL GetTaskDS(void);
WORD FAR PASCAL GetExePtr(HANDLE);
INT PILibHookInit (void) {
	RECT rect;
	OFSTRUCT of;
	char *pszName;
											 
	//Get and save complete name of DLL
	GetModuleFileName (hInst, szDLLName, sizeof (szDLLName));
	
	//See if current task is EXE.
	hEXEInst = GetExePtr (GetTaskDS());
	GetModuleFileName (hEXEInst, szTemp, sizeof (szTemp));
	pszName = strrchr (szTemp, '\\');
	if (strcmpi (pszName+1, szEXEName) == 0)
		strcpy (szEXEName, szTemp);
	else {	
		//No, use DLL path to search for and launch EXE.
		strcpy (szTemp, szDLLName);
		strcpy (strrchr (szTemp, '\\')+1, szEXEName);
		strcpy (szEXEName, szTemp);
		if (OpenFile (szEXEName, &of, OF_EXIST) != HFILE_ERROR) {
			lstrcpy (szEXEName, of.szPathName);
			WinExec (szEXEName, SW_HIDE);
		} else {
			lstrcpy (szTemp, "The Control Panel Applet: Place Icons "\
			         "could not find the required file, ");
			lstrcat (szTemp, szEXEName);
			MessageBox (NULL, szTemp, "Error", MB_ICONSTOP | MB_OK);
			return 1;
		}	
	}
	//Get and save desktop size
	GetClientRect (GetDesktopWindow (), &rect);
	sCxDesk = rect.right;
	sCyDesk = rect.bottom;
	//Get and save Icon size and spacing
	sCxIcon = GetSystemMetrics (SM_CXICON);
	sCyIcon = GetSystemMetrics (SM_CYICON);
	sCxISpacing = GetSystemMetrics (SM_CXICONSPACING);
	sCyISpacing = GetSystemMetrics (SM_CYICONSPACING);
	//Zero handle array
	ComputeIconPos (0, 0);
	return 0;
}	
//-----------------------------------------------------------
// PILibCPLTerm - Cleanup if control panel terminating
//-----------------------------------------------------------
INT PILibCPLTerm (void) {
	UINT fFlags;
	
	fFlags = PILibHookStat ();
	if (!(fFlags & STAT_INSTALLED)) {
		if (IsWindow (hEXEWnd)) {
			PostMessage (hEXEWnd, WM_CLOSE, 0, 0);
			hEXEWnd = 0;
		}
	}
	return 0;
}	
//-----------------------------------------------------------
// PILibHookTerm - Cleanup if terminating
//-----------------------------------------------------------
INT PILibHookTerm (void) {
	UINT fFlags;

	fFlags = PILibHookStat ();
	//Free message and shell hooks	
	if (fFlags & STAT_HOOKED) 
		PILibHookCtl (0, CTL_HOOK);
		
	//If installed, save status flags.	Else, erase section from
	// CONTROL.INI.
	if (fFlags & STAT_INSTALLED) 
		MyWritePrivateProfileInt (szProSec, PRO_FLAGS, fFlags, szProfileName);
	else
		WritePrivateProfileString (szProSec, NULL, NULL, szProfileName);

	return 0;
}	
//-----------------------------------------------------------
// PILibHookCtl - Controls subclassing the desktop window
// Hook, unhook
// Start side: l,r,t or b
//-----------------------------------------------------------
INT PILibHookCtl (UINT fNewFlags, UINT fDoFlags) {
	INT sRC = 0;
	HWND hDesktop;
	BOOL fFound = FALSE;

	if (fStatFlags == 0xffff) 
		return PILibHookStat();

	hDesktop = GetDesktopWindow();
	//See if we need to install or remove
	if (fDoFlags & CTL_IFLAG) {
		if ((fStatFlags & STAT_INSTALLED) && !(fNewFlags & STAT_INSTALLED)) {
			UninstallProgram (hInst);
		} else if (!(fStatFlags & STAT_INSTALLED) && (fNewFlags & STAT_INSTALLED)) {
			InstallProgram (hInst);
		}	
		fStatFlags &= ~STAT_INSTALLED;
		fStatFlags |= fNewFlags & STAT_INSTALLED;
	}
	//See if we need to hook the message queue
	if (fDoFlags & CTL_HOOK) {
		if ((fNewFlags & STAT_HOOKED) && (hShellHook == 0)) {
			//Hook message loop
			hShellHook = SetWindowsHookEx (WH_SHELL, 
		                               GetProcAddress (hInst, "ShellHookProc"),
		                               hInst, NULL);
			hCallHook = SetWindowsHookEx (WH_CALLWNDPROC, 
		                               GetProcAddress (hInst, "MsgHookProc"),
		                               hInst, NULL);
			fStatFlags |= STAT_HOOKED;
		} else if (!(fNewFlags & STAT_HOOKED) && (hShellHook)) {
			//Unhook message loop
 			UnhookWindowsHookEx (hShellHook);
	 		UnhookWindowsHookEx (hCallHook);
			hShellHook = 0;
			hCallHook = 0;

			fStatFlags &= ~STAT_HOOKED;
			ArrangeIconicWindows (GetDesktopWindow());
		}		
	}
	//See if we need to modify the parking position of the icons.
	if (fDoFlags & CTL_SIDES) {
		fStatFlags &= 0xfff8;
		fStatFlags |= fNewFlags & 0x07;
		if (fStatFlags & STAT_HOOKED) {
			ComputeIconPos (0, 0);   //Reset icon array
			ArrangeIcons();
			InvalidateRect (GetDesktopWindow(), NULL, TRUE);
		}	
	}
	return sRC;
}
//-----------------------------------------------------------
// PILibHookStat - Returns status flags 
//-----------------------------------------------------------
UINT PILibHookStat (void) {
	UINT fFlags;
	
	if (fStatFlags == 0xffff) {
		fStatFlags = 0;
		fFlags = GetPrivateProfileInt (szProSec, PRO_FLAGS, 0, szProfileName);
		PILibHookCtl (fFlags, CTL_IFLAG | CTL_HOOK | CTL_SIDES);
		fStatFlags = fFlags;		
	}
	return fStatFlags;
}	
//------------------------------------------------------------
// InstallProgram - Changes INI files to always launch program
//------------------------------------------------------------ 
INT InstallProgram (HINSTANCE hInstance) {
	char *pszName;

	//Mod LOAD line in WIN.INI
	GetProfileString ("Windows","Load", "", szTemp, sizeof (szTemp));
	AnsiUpper (szTemp);
	pszName = strstr (szTemp, szEXEName);
	if (pszName == 0) {
		strcat (szTemp, " ");
		strcat (szTemp, szEXEName);
		WriteProfileString ("Windows", "Load", szTemp);
	}
	//Add line to CONTROL.INI that loads Control Panel Applet.
	WritePrivateProfileString ("MMCPL","PCMagCPLApp", szDLLName, szProfileName);
	return 0;                              
}
//------------------------------------------------------------
// UninstallProgram - Changes INI files to remove references
// to program.
//------------------------------------------------------------ 
INT UninstallProgram (HINSTANCE hInstance) {
	char *pszPtr, *pszName;

	//Get LOAD line in WIN.INI
	GetProfileString ("Windows","Load", "", szTemp, sizeof (szTemp));
	pszName = strstr (szTemp, szEXEName);
	if (pszName) {
		//Back up to start of program name
		while ((pszName > szTemp) && (*(pszName-1) > ' '))
			pszName--;
		//Find end of name	
		pszPtr = strpbrk (pszName, " \t");
		//Copy end of string over file name.
		if (pszPtr) {
			while (*pszName++ = *pszPtr++)
				;
		} else
			*pszName = '\0';		
		WriteProfileString ("Windows", "Load", szTemp);
	}
	//Remove line from CONTORL.INI that loads Control Panel Applet.
	WritePrivateProfileString ("MMCPL","PCMagCPLApp", NULL, szProfileName);
	return 0;                              
}
//-----------------------------------------------------------
// ComputeIconPos - Computes the proper position of an icon
//-----------------------------------------------------------
void ComputeIconPos (HWND hWnd, LPPOINT pt) {
	static HWND hwndArray[MAXHANDLES];
	static INT sMaxActive;
	
	INT sNum, sRow, sCol, sLineCnt, sType;

	// If handle zero, init handle array
	if (hWnd == 0) {
		_fmemset (hwndArray, 0, sizeof (HWND) * MAXHANDLES);
		sMaxActive = 0;
		return;
	}
	// Find handle in array
	for (sNum = 0; sNum < sMaxActive; sNum++)
		if (hwndArray[sNum] == hWnd)
			break;
	// If point pointer zero, remove handle from the array
	if (pt == 0) {
		if (sNum < sMaxActive)
			hwndArray[sNum] = 0;
		return;	
	}
	// if handle not found in array, find first free handle				
	if (sNum == sMaxActive) {
		// Otherwise, find first free slot in array
		for (sNum = 0; sNum < MAXHANDLES; sNum++)
			if (hwndArray[sNum] == 0)
				break;
		if (sNum < MAXHANDLES) {
			hwndArray[sNum] = hWnd;
			if (sNum >= sMaxActive)
				sMaxActive++;
		}
	}	
	
	// Now, compute position using the index computed above
	sType = fStatFlags & 0x07;
	
	if ((sType ==  STAT_LEFT) || (sType ==  STAT_RIGHT)) {
		sLineCnt = (sCyDesk - sCyIcon) / sCyISpacing;
		sCol = sNum / sLineCnt;
		sRow = sNum % sLineCnt;

		pt->y = sRow * sCyISpacing + sCyISpacing/4;
		if (sType ==  STAT_LEFT)
			pt->x = (sCxISpacing * sCol) + sCxISpacing/2;
		else		
			pt->x = sCxDesk - (sCxISpacing * (sCol + 1));
	} else {
		sLineCnt = (sCxDesk - sCxIcon) / sCxISpacing;
		sCol = sNum % sLineCnt;
		sRow = sNum / sLineCnt;

		pt->x = sCol * sCxISpacing + sCxISpacing/4;
		if (sType ==  STAT_TOP)
			pt->y = (sCyISpacing * sRow) + sCyISpacing/2;
		else		
			pt->y = sCyDesk - (sCyISpacing * sRow) - sCyISpacing;
	}
	return; 
}	
//-----------------------------------------------------------
// ArrangeIcons - Arranges the icons on the desktop
//-----------------------------------------------------------
void ArrangeIcons (void) {
	WINDOWPLACEMENT wp;
	POINT pt;
	HWND hwndNext;
	LONG lStyle;

	wp.length = sizeof (wp);	
	//First, move iconized windows.
	hwndNext = GetWindow (GetDesktopWindow(), GW_CHILD);
	while (hwndNext) {
		lStyle = GetWindowLong (hwndNext, GWL_STYLE);

		if ((lStyle & WS_VISIBLE) && !(lStyle & WS_CHILD)) {

		 	if (IsIconic (hwndNext)) {
				GetWindowPlacement (hwndNext, &wp);

				//Set new icon position
				ComputeIconPos (hwndNext, &pt);
				wp.flags |= WPF_SETMINPOSITION;
				wp.ptMinPosition.x = pt.x;
				wp.ptMinPosition.y = pt.y;
				SetWindowPlacement (hwndNext, &wp);
				InvalidateRect (hwndNext, NULL, TRUE);
			}	
		}
		hwndNext = GetWindow (hwndNext, GW_HWNDNEXT);
	}	
	//Now remove iconic position for non-iconic windows.
	hwndNext = GetWindow (GetDesktopWindow(), GW_CHILD);
	while (hwndNext) {
		lStyle = GetWindowLong (hwndNext, GWL_STYLE);

		if ((lStyle & WS_VISIBLE) && !(lStyle & WS_CHILD)) {
		 	if (!IsIconic (hwndNext)) {
				GetWindowPlacement (hwndNext, &wp);
				wp.ptMinPosition.x = -2;
				wp.ptMinPosition.y = -2;
				wp.flags |= WPF_SETMINPOSITION;
				SetWindowPlacement (hwndNext, &wp);
			} 
		}
		hwndNext = GetWindow (hwndNext, GW_HWNDNEXT);
	}	
  	return;
}	
//============================================================
// General helper routines
//============================================================
//------------------------------------------------------------
// MyDisplayDialog - Display a dialog box
//------------------------------------------------------------ 
INT MyDisplayDialog (HINSTANCE hInstance, LPCSTR szDlgName,
                     HWND hWnd, WNDPROC lpDialogProc, 
                     LPARAM lParam) {
    WNDPROC lpDlgProcInst;
    INT		rc;

    lpDlgProcInst = MakeProcInstance(lpDialogProc, hInst);
    rc = DialogBoxParam (hInstance, szDlgName, hWnd, 
                         lpDlgProcInst, lParam);
    FreeProcInstance(lpDlgProcInst);
    return rc;                              
}
//------------------------------------------------------------
// MyWritePrivateProfileInt - Writes an integer to the profile
//------------------------------------------------------------
BOOL MyWritePrivateProfileInt (char *szSec, char *szEntry, 
                               int Num, char *szProfile) {
	static char	szStr[33];
	                           
	itoa (Num, szStr, 10);
	return WritePrivateProfileString (szSec, szEntry, szStr, 
	                                  szProfile);
}
//------------------------------------------------------------
// MySubClassWindow - Subclasses a window 
//------------------------------------------------------------
WNDPROC MySubClassWindow (HWND hWnd, WNDPROC lpfnNewProc) {
   WNDPROC lpfnOldProc;

	lpfnOldProc = (WNDPROC) GetWindowLong (hWnd, GWL_WNDPROC);
	SetWindowLong (hWnd, GWL_WNDPROC, (LONG) lpfnNewProc);
	return lpfnOldProc;				               
}				               
