//===========================================================
// PLICON - An Icon posistioner for Windows
// Copyright (C) 1995 Douglas Boling
//===========================================================
// Max number of bitmaps and text objects on desk
#define MAXOBJECTS            32

//-----------------------------------------------------------
// Include files
//-----------------------------------------------------------
#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>

#include "plidll.h"

//-----------------------------------------------------------
// Function prototypes
//-----------------------------------------------------------
INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
//
// Message functions
//
LONG DoResetIPosMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoEndSessionMain (HWND, UINT, UINT, LONG);
//
// Button functions
//
LONG DoMainCtlInstall (HWND, UINT, HWND, UINT);
LONG DoMainCtlAbout (HWND, UINT, HWND, UINT);
LONG DoMainCtlExit (HWND, UINT, HWND, UINT);
//------------------------------------------------------------
// Message dispatch table for MainWindowProc
//------------------------------------------------------------
struct decodeUINT MainMessages[] = {
	MYMSG_RESETIPOS, DoResetIPosMain,
	WM_SIZE, DoSizeMain,
	WM_COMMAND, DoCommandMain,
	WM_CLOSE, DoCloseMain, 
	WM_DESTROY, DoDestroyMain, 
	WM_ENDSESSION, DoEndSessionMain, 
};
//------------------------------------------------------------
// Command Message dispatch for MainWindowProc
//------------------------------------------------------------
struct decodeCMD MainCMDItems[] = {
	IDD_INSTALL, DoMainCtlInstall,
	IDD_ABOUT, DoMainCtlAbout,
	IDCANCEL, DoMainCtlExit,
	IDD_EXIT, DoMainCtlExit,
};
//-----------------------------------------------------------
// Global data
//-----------------------------------------------------------
char szAppName[] = "plicon";            // Application name
char szTitleText[] = "Place Icon";      // Window title text
char szIconName[] = "pliconIcon";       // Icon name
char szProfileName[] = "PLICON.INI";    // INI file name

HANDLE hInst;
HWND hMain;
//============================================================
// WinMain -- entry point for this application from Windows.
//============================================================
INT APIENTRY WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                     LPSTR lpCmdLine, INT nCmdShow) {
	MSG	msg;
	INT	rc;

	hInst = hInstance;
	// If not first instance, launch control panel applet and terminate.
   if (hPrevInstance) {
		WinExec ("Control Place Icons", SW_SHOW);	
		return 0;
	}	
	// Init Application
	if((rc = InitApp(hInstance)) != 0)
		return rc;
	// Initialize this instance
	if((rc = InitInstance(hInstance, lpCmdLine, nCmdShow)) != 0)
		return rc;
	// Application message loop
	while (GetMessage (&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	// Instance cleanup
	return TermInstance(hInstance, msg.wParam);
}
  
//-----------------------------------------------------------
// InitApp - Global initialization code for this application.
//-----------------------------------------------------------
INT InitApp(HANDLE hInstance) {
	WNDCLASS  wc;
	//
	// Register App Window class
	//
	wc.style = 0;                             // Window style
	wc.lpfnWndProc = MainWndProc;             // Callback function
	wc.cbClsExtra = 0;                        // Extra class data
	wc.cbWndExtra = DLGWINDOWEXTRA;           // Extra window data
	wc.hInstance = hInstance;                 // Owner handle
	wc.hIcon = LoadIcon(hInst, szIconName);   // Application icon
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); // Default cursor
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH); // Background color 
	wc.lpszMenuName = 0;                      // Menu name
	wc.lpszClassName = szAppName;             // Window class name

	if (!RegisterClass(&wc))
		return 1;
 	return 0;
}

//-----------------------------------------------------------
// InitInstance - Instance initialization code for this app.
//-----------------------------------------------------------
INT InitInstance(HANDLE hInstance, LPSTR lpCmdLine, INT nCmdShow) {
	int	x,y;
	UINT fFlags;

	x  = GetPrivateProfileInt (szAppName, PRO_XPOS, 100, szProfileName);
	y  = GetPrivateProfileInt (szAppName, PRO_YPOS, 100, szProfileName);
	
   hMain = CreateDialog (hInstance, szAppName, 0, NULL);
	if(!hMain) return 0x10;           
	SetWindowPos (hMain, NULL, x, y, 0, 0, SWP_NOSIZE);

	//First, send handle to this window
	fFlags = GetSetDLLFlags (hMain, CTL_HANDLE);
	//Now, tell the DLL to configure properly.
	fFlags = GetSetDLLFlags (fFlags, CTL_IFLAG | CTL_HOOK | CTL_SIDES);
	
	//Show window only if not installed.
	if (!(fFlags & STAT_INSTALLED)) {
		ShowWindow(hMain, nCmdShow | SW_SHOW);
		UpdateWindow(hMain);           // force WM_PAINT message
	} else
		ShowWindow(hMain, SW_HIDE);
	return 0;                         // return success flag
}

//------------------------------------------------------------
// TermInstance - Instance termination code for this app.
//------------------------------------------------------------
INT TermInstance(HANDLE hinstance, int sDefRC) {
	return sDefRC;
}
//============================================================
// Message handling procedures for MainWindow
//============================================================
//------------------------------------------------------------
// MainWndProc - Callback function for application window
//------------------------------------------------------------
LONG CALLBACK MainWndProc(HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	for(i = 0; i < dim(MainMessages); i++) {
		if(wMsg == MainMessages[i].Code)
			return (*MainMessages[i].Fxn)(hWnd, wMsg, wParam, lParam);
	}
	return DefWindowProc(hWnd, wMsg, wParam, lParam);
}

//------------------------------------------------------------
// DoResetIPosMain - process MYMSG_RESETIPOS custom message.
//------------------------------------------------------------ 
LONG DoResetIPosMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	WINDOWPLACEMENT wp;
	LONG lStyle;

	lStyle = GetWindowLong ((HWND) wParam, GWL_STYLE);

	if ((lStyle & WS_VISIBLE) && !(lStyle & WS_CHILD)) {

		wp.length = sizeof (wp);	
		GetWindowPlacement ((HWND) wParam, &wp);
		if ((wp.showCmd == SW_MINIMIZE) ||
		    (wp.showCmd == SW_SHOWMINNOACTIVE) ||
		    (wp.showCmd == SW_SHOWMINIMIZED))	{

			//Set new icon position
			ComputeNextIPos ((HWND) wParam, &wp.ptMinPosition);
		} else {
			wp.ptMinPosition.x = -2;
			wp.ptMinPosition.y = -2;
		}	
		wp.flags |= WPF_SETMINPOSITION;
		SetWindowPlacement ((HWND) wParam, &wp);
	}
	
	return 0;
}
//------------------------------------------------------------
// DoSizeMain - process WM_SIZE message for frame window.
//------------------------------------------------------------ 
LONG DoSizeMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	UINT fFlags;
	
	fFlags = GetSetDLLFlags (0, 0);
	if (fFlags & CTL_IFLAG)
		SetDlgItemText (hWnd, IDD_INSTALL, "&Uninstall");
	else
		SetDlgItemText (hWnd, IDD_INSTALL, "&Install");

	return DefDlgProc(hWnd, wMsg, wParam, lParam);
}
//------------------------------------------------------------
// DoCommandMain - process WM_COMMAND message for frame window 
// by decoding the menubar item with the CMDItems[] array, 
// then running the corresponding function to process the command.
//------------------------------------------------------------ 
LONG DoCommandMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	UINT	idItem, wNotifyCode;
	HWND	hwndCtl;

	idItem = (UINT) wParam;                      // Parse Parameters
	hwndCtl = (HWND) LOWORD(lParam);
	wNotifyCode = (UINT) HIWORD(lParam);
	//
	// Call routine to handle control message
	//
	for(i = 0; i < dim(MainCMDItems); i++) {
		if(idItem == MainCMDItems[i].Code)
			return (*MainCMDItems[i].Fxn)(hWnd, idItem, hwndCtl, 
			                               wNotifyCode);
	}
	return DefWindowProc(hWnd, wMsg, wParam, lParam);
}
//------------------------------------------------------------
// DoCloseMain - process WM_CLOSE message for frame window.
//------------------------------------------------------------ 
LONG DoCloseMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {

	DestroyWindow(hWnd);
	return 0;
}
//------------------------------------------------------------
// DoDestroyMain - process WM_DESTROY message for frame window.
//------------------------------------------------------------ 
LONG DoDestroyMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
   RECT	rect;

	//Save Window position
	if	(!IsIconic (hWnd)) {
		GetWindowRect (hWnd, &rect);
		MyWritePrivateProfileInt (szAppName, PRO_XPOS, rect.left,
		                          szProfileName);
		MyWritePrivateProfileInt (szAppName, PRO_YPOS, rect.top,
		                          szProfileName);
	}
	PostQuitMessage (0);
	return 0;
}
//------------------------------------------------------------
// DoEndSessionMain - process WM_ENDSESSION message for window.
//------------------------------------------------------------ 
LONG DoEndSessionMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {

	return 0;
}

//============================================================
// Control handling procedures for MainWindow
//============================================================
//------------------------------------------------------------
// DoCtlInstall - Process Install button
//------------------------------------------------------------ 
LONG DoMainCtlInstall (HWND hWnd, UINT idItem, HWND hwndCtl, 
                    UINT wNotifyCode) {
	UINT fFlags;

	fFlags = GetSetDLLFlags (0, 0);
	if (fFlags & STAT_INSTALLED) {
		//Remove code
		SetDlgItemText (hWnd, IDD_INSTALL, "&Install");
		fFlags = GetSetDLLFlags (0, CTL_IFLAG);
	} else {
		//Install code
		SetDlgItemText (hWnd, IDD_INSTALL, "&Uninstall");
		ShowWindow (hWnd, SW_HIDE);
		fFlags = GetSetDLLFlags (STAT_INSTALLED, CTL_IFLAG);
		WinExec ("Control Place Icons", SW_SHOW);	
	}
	return 0;
}
//------------------------------------------------------------
// DoCtlAbout - Process About button
//------------------------------------------------------------ 
LONG DoMainCtlAbout (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
	ShowAboutDialog(hWnd);
	return 0;
}
//------------------------------------------------------------
// DoMainCtlExit - Process Cancel button
//------------------------------------------------------------ 
LONG DoMainCtlExit (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
	SendMessage (hWnd, WM_CLOSE, 0, 0);
	return TRUE;
}
//============================================================  
// General Helper Routines 
//============================================================  
//------------------------------------------------------------
// MyWritePrivateProfileInt - Writes an integer to the profile
//------------------------------------------------------------
BOOL MyWritePrivateProfileInt (char *szSec, char *szEntry, 
                               int Num, char *szProfile) {
	char	szStr[33];
	                           
	itoa (Num, szStr, 10);
	return WritePrivateProfileString (szSec, szEntry, szStr, 
	                                  szProfile);
}
