// sehdump.cpp RHS 8/12/94

#include<windows.h>
#include<string.h>
#include<excpt.h>
#include<stdio.h>

const MAX_EXCEPTIONS = 21;
struct _ExceptionCodeNames
    {
    char *name;
    DWORD code;
    } ExceptionCodeNames[MAX_EXCEPTIONS] = 
    {
    
    {"Access Violation",					EXCEPTION_ACCESS_VIOLATION     },
    {"Datatype Misalignment",				EXCEPTION_DATATYPE_MISALIGNMENT},
    {"Breakpoint",           				EXCEPTION_BREAKPOINT           },
    {"Single Step",          				EXCEPTION_SINGLE_STEP          },
    {"Array Bounds Exceeded",				EXCEPTION_ARRAY_BOUNDS_EXCEEDED},
    {"Floating Point: denormal Operand",	EXCEPTION_FLT_DENORMAL_OPERAND },
    {"Floating Point: divide by Zero",		EXCEPTION_FLT_DIVIDE_BY_ZERO   },
    {"Floating Point: inexact Result",  	EXCEPTION_FLT_INEXACT_RESULT   },
    {"Floating Point: invalid operation",	EXCEPTION_FLT_INVALID_OPERATION},
    {"Floating Point: overflow",			EXCEPTION_FLT_OVERFLOW         },
    {"Floating Point: Stack Check",			EXCEPTION_FLT_STACK_CHECK      },
    {"Floating Point: Underflow",			EXCEPTION_FLT_UNDERFLOW        },
    {"Integer divide by zero",				EXCEPTION_INT_DIVIDE_BY_ZERO   },
    {"Integer overflow",					EXCEPTION_INT_OVERFLOW         },
    {"Privileged Instruction",				EXCEPTION_PRIV_INSTRUCTION     },
    {"In page error",						EXCEPTION_IN_PAGE_ERROR        },
	{"Illegal Instruction",					EXCEPTION_ILLEGAL_INSTRUCTION	},
	{"Non-continuable Exception",			EXCEPTION_NONCONTINUABLE_EXCEPTION},
	{"Stack Overflow",						EXCEPTION_STACK_OVERFLOW},
	{"Invalid Disposition",					EXCEPTION_INVALID_DISPOSITION},
	{"Guard Page",							EXCEPTION_GUARD_PAGE}
	};

char *GetExceptionCodeName(DWORD code)
    {
    for(int i = 0; i < MAX_EXCEPTIONS; i++)
        if(code == ExceptionCodeNames[i].code)
            return ExceptionCodeNames[i].name;
    return "";
    }    

void PrintExceptionInfo(LPEXCEPTION_POINTERS myInfo)
    {
    EXCEPTION_RECORD er = *(myInfo->ExceptionRecord);    // struct assign

    while(TRUE)
        {
		char exceptiontype[30];
		if(er.ExceptionCode == EXCEPTION_ACCESS_VIOLATION)
			sprintf(exceptiontype,"%s violation",
				(er.ExceptionInformation[0] == 0) ? "read" : "write");
		else
			exceptiontype[0] = '\0';

		char buf[150];
        sprintf(buf,
        	"%s Exception: %s @ address 0x%lp (exception code 0x%08x)"
        	", %scontinuable",

            GetExceptionCodeName(er.ExceptionCode),
			exceptiontype,
			er.ExceptionAddress,
            er.ExceptionCode, 
            (er.ExceptionFlags == 0) ? "" : "NON-");
		MessageBox(NULL,buf,GetCommandLine(),MB_ICONEXCLAMATION);

        if(er.ExceptionRecord)
            er = *er.ExceptionRecord;
        else
            break;
        }
    }         


DWORD FilterFunction(LPEXCEPTION_POINTERS Info)
    {
	PrintExceptionInfo(Info);
    return EXCEPTION_EXECUTE_HANDLER;
    }

int WINAPI WinMain(HANDLE, HANDLE, LPSTR, int)
    {
    __try
        {
		char *p = NULL;
     	*p = 'a';   // trigger exception by writing to NULL pointer
        			// this line never executed
        }
    __except(FilterFunction(GetExceptionInformation())) 
        {
        // insert exception handling here...
        }
    return 0;
    }

