//===========================================================
// SCHED.H -- Header File 
// Copyright (c) 1994 Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
/*
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif
*/
  #define INT       int
  #define APIENTRY  PASCAL


//
// Error numbers
//
#define ERR_LAUNCH        16
#define ERR_DOS           64

#define ERR_BADDATE       -1
#define ERR_BADTIME       -2
#define ERR_NOSELECT      -3
#define ERR_TIMEPAST      -4
#define ERR_NOCMDLINE     -5
#define ERR_BADINTERVAL   -6
#define ERR_MAXSCH        -7
#define ERR_NOSCHSEL      -8
//
// Flags
//
#define SCH_ONCE      1
#define SCH_DAY       2
#define SCH_WEEK      3
#define SCH_MONTH     4
#define SCH_EXPIRED   5

#define SCH_ERROR     0x08
#define SCH_ICON      0x10
#define SCH_ACTIVATE  0x20

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
//
// Schedule entry foramt
//
typedef struct {
	UINT	fFlags;
	LONG 	lData;
	LONG 	lTime;
	LONG 	lNextTime;
	char	szCmd[MAXCMDLINELEN];
	char	szDir[MAXCMDLINELEN];
} SCHENTRY;
typedef SCHENTRY *PSCHENTRY;
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, DLGPROC, LPARAM);
void PrintError (HWND, INT);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
BOOL MyWritePrivateProfileLong (char *, char *, LONG, char *);
LONG MyGetPrivateProfileLong (char *, char *, LONG, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
//
// Program specific prototypes
//
// Window procedures
LONG CALLBACK EditSCProc(HWND, UINT, UINT, LONG);
// Dialog box functions
BOOL CALLBACK AddDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoTimerMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainCtlProgList (HWND, UINT, HWND, UINT);
LONG DoMainCtlAdd (HWND, UINT, HWND, UINT);
LONG DoMainCtlDel (HWND, UINT, HWND, UINT);
LONG DoMainCtlEdit (HWND, UINT, HWND, UINT);
LONG DoMainCtlAbout (HWND, UINT, HWND, UINT);
LONG DoMainCtlExit (HWND, UINT, HWND, UINT);

void SavetoINI (void);
char *DateToAsc (LONG, char *, INT);
char *TimeToAsc (LONG, char *, INT);
LONG AscToDate (char *);
LONG AscToTime (char *);
LONG ComputeNext (PSCHENTRY);
void StartTimer (void);
void SetButtons (HWND);
void FillLB (HWND);

typedef struct tm TM;
//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"

#define     PRO_LST       "Array"
#define     PRO_CNT       "ArrayCnt"
#define     PRO_FLAGS     "Flags"
#define     PRO_TIME      "Time"
#define     PRO_NEXT      "Next"
#define     PRO_DATA      "Value"
#define     PRO_CMD       "Cmd"
#define     PRO_DIR       "Dir"
//
// Resource Idendifiers
//
#define     IDD_PROGLIST   100
#define     IDD_ADD        101
#define     IDD_DEL        102
#define     IDD_EDIT       103
#define     IDD_ABOUT      104
#define     IDD_EXIT       105

#define     IDD_ONCE       200
#define     IDD_DAY        201
#define     IDD_WEEK       202
#define     IDD_MONTH      203
#define     IDD_STIME      204
#define     IDD_DETAIL     205
#define     IDD_TEXT1      206
#define     IDD_EDIT1      207
#define     IDD_TIMETEXT   209
#define     IDD_LIST1      210
#define     IDD_CMD        211
#define     IDD_WDIR       212
#define     IDD_ACTIVATE   213
#define     IDD_ICON       214
#define     IDD_ADDBROWSE  215

#define     IDD_PROGSTR    300
#define     IDD_FRAME      301
