Unit CStr;
{Various procedures for handling C style null terminated strings}
Interface

Function StrTok(S,Delim:PChar):PChar;
Function StrDelta(S1,S2:PChar):Word;
Function StrVal(S:PChar; N:Word):Word;

Implementation

Uses WinProcs, Strings;

Const S1:PChar = Nil;

Function StrTok(S,Delim:PChar):PChar;
{Implement the C function StrTok which breaks a string into a series
 of token delimited substrings. This function modifies the source string.
 Only one string can be scanned at a time.
 Returns a pointer to the next substring or NIL if no more

 Input:  S - String to scan
         Delim - Set of delimiters}

Var Len,I:Word;

	Begin
   If S <> Nil then S1:=S;
   Len:=StrLen(Delim);
   StrTok:=S1;
   If (S1 <> Nil) and (Delim <> Nil) and
      (Len > 0) and (StrLen(S1) > 0) then
      While S1[0] <> #00 do
      	Begin
         For I:=0 to Len-1 do
         	If S1[0] = Delim[I] then
            	Begin
               S1[0]:=#00;
               Inc(S1);
               Exit;
               End;
         Inc(S1);
         End;
   End;

Function StrDelta(S1,S2:PChar):Word;
{Computes the number of characters between two pointers to the same string.
 Returns the difference between the two pointers.

 Input:  S1 - First pointer
         S2 - Second pointer}

   Var L1:LongInt absolute S1;
       L2:LongInt absolute S2;

   Begin
   If HiWord(L1) <> HiWord(L2) then
      StrDelta:=0       {Must point to same selector}
   else
      StrDelta:=Abs(LoWord(L2)-LoWord(L1));
   End;

Function StrVal(S:PChar; N:Word):Word;
{Similar to the Val function. Converts a sequence of numeric characters
 into a Word variable. No error checking is performed.
 Returns the value of the string.

 Input:  S - String to be converted
         N - Number of characters to be converted (max 10)}

Var I,Result:Word;
    Buf:Array [0..10] of Char;

   Begin
   If N >= Sizeof(Buf) then N:=Sizeof(Buf)-1;
   StrLCopy(Buf,S,N);
   Val(Buf,I,Result);
   StrVal:=I;
   End;

Begin
End.