;******************************************************************************
;
; VTUTORD.386 is a simple VxD that allows a DOS application to determine
; the number of virtual machines in the system. Windows apps run in one VM
; (the system VM), and DOS apps run in separate DOS VMs.
;
; To load the VxD, add a DEVICE=VTUTORD.386 command to the [386Enh] section of
; SYSTEM.INI. To retrieve its entry point from a V86-mode program, call int 2Fh
; with AX=1684h and BX=7FE1h. When the entry point is called, VTUTORD returns
; the VM count in register (E)AX.
;
; Note: The device ID used by VTUTORD is not registered. Therefore, there
; is no guarantee that it will not conflict with other VxDs, although the
; possibility of a conflict is remote.
;
;******************************************************************************

        .386p

;******************************************************************************
;                             I N C L U D E S
;******************************************************************************

        .XLIST
        INCLUDE VMM.INC
        .LIST

;******************************************************************************
;                             E Q U A T E S
;******************************************************************************

VTUTORD_Major_Ver  equ     1
VTUTORD_Minor_Ver  equ     0
VTUTORD_Device_ID  equ     7FE1h

;******************************************************************************
;              V I R T U A L   D E V I C E   D E C L A R A T I O N
;******************************************************************************

Declare_Virtual_Device VTUTORD,\
                       VTUTORD_Major_Ver, VTUTORD_Minor_Ver,\
                       VTUTORD_Control,\
                       VTUTORD_Device_ID,,\
                       VTUTORD_API_Proc,

;******************************************************************************
;                      P A G E - L O C K E D   C O D E
;******************************************************************************

VxD_LOCKED_CODE_SEG

;
; VTUTORD_Control receives and dispatches system control messages.
;

BeginProc VTUTORD_Control

        clc                             ;Clear the carry flag and return
        ret

EndProc VTUTORD_Control

VxD_LOCKED_CODE_ENDS

;******************************************************************************
;                               C O D E
;******************************************************************************

VxD_CODE_SEG

;
; VTUTORD_API_Proc is the exported API procedure that V86 mode apps can call.
; On return, the caller's EAX register holds the VM count.
;

BeginProc VTUTORD_API_Proc

        mov     ecx,0                   ;Set VM count to 0
        mov     eax,ebx                 ;Save handle of current VM

VAPI_Loop:
        inc     ecx                     ;Increment the VM count
        VMMcall Get_Next_VM_Handle      ;Get the next VM handle
        cmp     ebx,eax                 ;Loop back if it isn't the handle
        jne     VAPI_Loop               ;of the current VM

        mov     [ebp.Client_EAX],ecx    ;Copy ECX to the caller's EAX
        ret                             ;Return to the caller

EndProc VTUTORD_API_Proc

VxD_CODE_ENDS

        END
