//===========================================================
// Switcher.H -- Header File 
// Copyright (c) 1993 Douglas Boling
//===========================================================
// Equates used by program
#define BTNMAX              16
#define MAXNAMELEN          32
#define MAXSPLEN            128
#define MAXEPLEN            128

#define FLAGS_RESAVE        1
#define FLAGS_MDATAGOOD     2
#define SWF_VERT            1
#define SWF_SHOWMENU        2
//
// Error numbers
//
#define MYDOSERR            256
#define ERR_CANCELED        -1
#define ERR_OUTOFMEM        -2
#define ERR_TOOMANYBUTTONS  -3
#define ERR_BTNWNDCREATE    -4
#define ERR_NOMOREBTNS      -5
#define ERR_CANTWRITEDATA   -6
#define ERR_BADLAUNCH       -7

//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#define WIN16       TRUE
#define INT         int
#define UINT        WORD
#define APIENTRY    PASCAL
#define WNDPROC     FARPROC

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
// structure used by GetSetMouseData
typedef struct {
	BYTE bMouseType;				//1-Bus, 2-Serial, 3-InPort 4-PS/2
	BYTE bData2;					//Unknown
	LPVOID lpNewMouseFunc;			//Pointer to new mouse event proc
	INT sMouseVer;					//Mouse.drv version
	INT sMouseOrientation;			//Mouse Orientation
	UINT usMouseBtnAssign;			//Mouse button assignments
	BYTE bData7;					//Unknown
	UINT usMouseSpeed;				//Byte values for x any y sensitivity
	BYTE bData9;					//Related to accel table names
	LPBYTE lpAccelTbl;				//Pointer to acceleration table data
	LPBYTE lpAccelNames;  			//Pointer to acceleration table names
	BYTE bAccelActive;				//Inticates which accel table is active
	LPSTR lpszProfileName;			//Pointer to buffer for profile name
} MOUSEDATA;	   
typedef MOUSEDATA far * LPMOUSEDATA;

typedef INT (FAR PASCAL *LPMOUSEFUNC) (LPMOUSEDATA, DWORD);

typedef struct {
	INT fFlags;
	char szName[MAXNAMELEN];
	char szSProg[MAXSPLEN];
	char szEProg[MAXEPLEN];

	BOOL fBeep;
	INT sBorder;
	INT sDeskGrid;
	INT sIconHSpacing;
	INT sIconVSpacing;
	LOGFONT fdIconFont;
	BOOL fIconTitleWrap;
	char szWallpaper[128];
	INT sWallpaperTile;
	char szPattern[33];
	char szScrnSaveName[128];
	char szScrnSavePW[24];
	BOOL fScrnSaveAct;
	INT sScrnSaveTime;
	INT sKeyDelay;
	INT sKeySpeed;
	COLORREF rgbColors[21];
	char szColorScheme[64];
	INT sMouse[3];
	BOOL fBtnSwap;
	INT sDblClkHeight;
	INT sDblClkWidth;
	INT sDblClkSpeed;
	UINT usMouseSensitivity;
	INT sMouseOrientation;
	UINT usMouseButtons;
	BYTE bMAccelActive;
	BYTE bMAccelTbl[260];
	BYTE bMAccelNames[64];
	char szMProAPL[4][17];
	char szMProAPM[4][128];
	char szMProAPF[4][128];
	INT sMProHSen;
	INT sMProVSen;
	INT sMProRot; 
	INT sMProPriB;
	INT sMProSecB;
	INT sMProAAP; 
} BTNDATA;	   
typedef BTNDATA far * LPBTNDATA;

typedef struct {
	char szVerify[8];
	INT sWinPosX;
	INT sWinPosY;
	INT fFlags;
	INT sBtnCnt;
	INT sBtnRows;
	INT sCurrSelected;
	BTNDATA bdArray[BTNMAX];
} SWDATA;	   
typedef SWDATA far * LPSWDATA;

//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
void MyPrintError (HWND, INT);
INT MyCopyFile (char *, char *);
//
// Data types needed for program
//
typedef struct find_t FIND_T;
typedef struct DOSERROR DOSERR;
//
// Program specific prototypes
//
// Dialog functions
BOOL CALLBACK ConfigDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK AddBtnDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK DelBtnDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoInitMenuMain (HWND, UINT, UINT, LONG);
LONG DoPaintMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainMenuConfig (HWND, UINT, HWND, UINT);
LONG DoMainMenuExit (HWND, UINT, HWND, UINT);
LONG DoMainMenuBtnAdd (HWND, UINT, HWND, UINT);
LONG DoMainMenuBtnEdit (HWND, UINT, HWND, UINT);
LONG DoMainMenuBtnDel (HWND, UINT, HWND, UINT);
LONG DoMainMenuAbout (HWND, UINT, HWND, UINT);
LONG DoMainBtnClick (HWND, UINT, HWND, UINT);
// Utility function prototypes
INT CreateButtons (HWND);
LONG GetBtnDim (LPBTNDATA, INT, INT);
INT WriteBtnData (void);
void SetMenuConfig (HWND, BOOL);
void SaveState (LPBTNDATA);
void RestoreState (LPBTNDATA);
void DisplayCurrStatus (HWND);
//
// Resource Identifiers
//
#define     MENU_SWITCHER    0
#define     MENU_BUTTONS     1
#define     MENU_HELP        2

#define     IDM_CONFIG       100
#define     IDM_EXIT         101

#define     IDM_BTNADD       110
#define     IDM_BTNEDIT      111
#define     IDM_BTNDEL       112

#define     IDM_ABOUT	     120

#define     IDD_BYROWS       130
#define     IDD_BYCOLUMNS    131
#define     IDD_ROWTAG       132 
#define     IDD_NUMROWS      133
#define     IDD_SHOWMENU     134

#define     IDD_BUTTONS      200

#define     IDD_BTNNAME      300
#define     IDD_PROGLIST     301
#define     IDD_TERMPROG     302
#define     IDD_RESAVE       303

#define     IDD_DELTEXT      350
#define     IDD_DELLIST      351

#define     IDD_PROGSTR      600



