#include <windows.h>
#include <mmsystem.h>

#include <stdio.h>

RECT rcMovie;

long FAR PASCAL __export WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
    
    PAINTSTRUCT ps;

    // Process the windows message
    switch (message) {
        case WM_PAINT:
            if (!BeginPaint (hWnd, &ps))
                return 0;
            EndPaint (hWnd, &ps);
            return 0;
        case WM_DESTROY:
            PostQuitMessage (0);
            return 0;
        case WM_LBUTTONDOWN:
            mciSendString ("stop coolMovie", NULL, 0, 0);
            return 0;
        case WM_LBUTTONDBLCLK:
            mciSendString ("seek coolMovie to start", NULL, 0, 0);
            mciSendString ("play coolMovie", NULL, 0, 0);
            return 0;
    }

    // Return to Windows
    return DefWindowProc (hWnd, message, wParam, lParam);
}

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpszCmd, int nCmdShow) {

    HWND hWnd;
    MSG msg;
    WNDCLASS wndclass;
    
    static char szCommand[80];
    static char szResult[80];
    static char szAppName[] = "MCI";

    // Register and create main window
    if (!hPrev) {
        wndclass.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon (NULL,IDI_APPLICATION);
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;
        RegisterClass (&wndclass);
    }

    hWnd = CreateWindow (szAppName, szAppName, WS_CAPTION | WS_SYSMENU |
      WS_CLIPCHILDREN | WS_OVERLAPPED, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

    // Instantiate the movie 
    mciSendString ("open SAMPLE.AVI alias coolMovie", NULL, 0, 0);

    // Make the frame just big enough for the movie
    mciSendString ("where coolMovie destination wait", szResult, sizeof szResult, 0);
    sscanf (szResult, "%d %d %d %d", &rcMovie.left, &rcMovie.top, &rcMovie.right, &rcMovie.bottom);
    AdjustWindowRect (&rcMovie, WS_CAPTION | WS_OVERLAPPED, FALSE);
    OffsetRect (&rcMovie, -rcMovie.left, -rcMovie.top);
    SetWindowPos (hWnd, 0, 0, 0, rcMovie.right, rcMovie.bottom, SWP_NOMOVE | SWP_NOZORDER);
    
    // Show the movie
    wsprintf (szCommand, "window coolMovie handle %u state show", (unsigned int) hWnd);
    mciSendString (szCommand, NULL, 0, 0);
    wsprintf (szCommand, "put coolMovie destination at %u %u %u %u", 0, 0, rcMovie.right, rcMovie.bottom);
    mciSendString (szCommand, NULL, 0, 0);
    mciSendString ("seek coolMovie to start", NULL, 0, 0);
    
    // Show the window
    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);

    // Play the movie
    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    // Clean up
    mciSendString ("close coolMovie", NULL, 0, 0);

    // Return to Windows
    return msg.wParam;
}

