// VCN.HPP Part of VULCAN
// Copyright (c) 1993 John Deurbrouck
// must include time.h before this file
#define SIGNATURE 0x6
// INFLATION used to pump up raw file size to account for header data
#define INFLATION 200L

#pragma pack(1)
struct vcn_info{
// following stored in each .VCN file and in VULCAN.VCN
    long Index;
    long FileSize; // refers to *original* file
    unsigned FileDate,FileTime,Attrib; // refers to *original* file
    int DispChar; // shows whether file is a part of a group
    unsigned version:4, // 1 is first released version
        compressed:4, // 0 for no compression, nbr indicates algorithm
        signature:4; // signature should be SIGNATURE
    char _far *FullName; // NULL if full data not yet read
    // in file, unsigned byte is length incl. terminator, then data & NULL
// following derived from directory entry or preceding
    char _far *FileName; // may overlap with previous
    unsigned StoredDate,StoredTime;
    long StoredSize;
};
#pragma pack()
extern int vcnSetup(void); // call after szTargetDirectory set
extern void vcnGetFilenumberRange(long &bottom,long &top);
extern int vcnGetInfo(long index,vcn_info &vcn);
extern int vcnGetRecordAfter(long index,vcn_info &vcn); // next higher index
extern int vcnGetRecordBefore(long index,vcn_info &vcn); // next lower index
extern int vcnPutInfo(vcn_info &vcn); // does not write to disk, allocates
                                      // space for new item if necessary
extern void vcnDeleteOldestItem(); // deletes from disk too
extern void vcnDeleteItem(long index,int delete_file=1); // from disk, queue
extern long vcnGetTargetDiskBytes(); // takes free space into account
extern long vcnGetActualDiskBytes(); // includes all VCN files
extern int vcnAddBytesRequiresSomeDelete(long bytes);
extern long vcnAdjustForClusterSize(long siz);
extern void vcnForceToCorrectSize(long space=0L);
    // delete old guys until within spec
    // if adding a file, pass its size to prerelease room
extern void vcnSaveVcnFile(void); // saves queue to disk
extern void vcnDestroy(void); // saves queue to disk, frees memory
extern int vcnWriteEntry(vcn_info& vcn,int fhandle,int* hsize=NULL);
    // just vcn, filename. 0 failure, 1 success
    // if hsize non-null, puts nbr bytes written there
extern int vcnReadEntry(vcn_info* vcnp,char* filename,int fhandle);
    // returns 1 for successful read, 0 for EOF, error or garbage
