/*----------------------------------------
   HATCHES.C -- Windows NT Hatch Patterns
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>

char szClass [] = "Hatches" ;
char szTitle [] = "Hatches: Windows NT Hatch Patterns" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static struct
          {
          int    iIdent ;
          char * cLabel ;
          }
          hatches [] = { HS_HORIZONTAL,      "HS_HORIZONTAL",
                         HS_VERTICAL,        "HS_VERTICAL",
                         HS_FDIAGONAL,       "HS_FDIAGONAL",
                         HS_BDIAGONAL,       "HS_BDIAGONAL",
                         HS_CROSS,           "HS_CROSS",
                         HS_DIAGCROSS,       "HS_DIAGCROSS",
                         HS_FDIAGONAL1,      "HS_FDIAGONAL1",
                         HS_BDIAGONAL1,      "HS_BDIAGONAL1",
                         HS_SOLID,           "HS_SOLID",
                         HS_DENSE1,          "HS_DENSE1",
                         HS_DENSE2,          "HS_DENSE2",
                         HS_DENSE3,          "HS_DENSE3",
                         HS_DENSE4,          "HS_DENSE4",
                         HS_DENSE5,          "HS_DENSE5",
                         HS_DENSE6,          "HS_DENSE6",
                         HS_DENSE7,          "HS_DENSE7",
                         HS_DENSE8,          "HS_DENSE8",
                         HS_NOSHADE,         "HS_NOSHADE",
                         HS_HALFTONE,        "HS_HALFTONE",
                         HS_SOLIDCLR,        "HS_SOLIDCLR",
                         HS_DITHEREDCLR,     "HS_DITHEREDCLR",
                         HS_SOLIDTEXTCLR,    "HS_SOLIDTEXTCLR",
                         HS_DITHEREDTEXTCLR, "HS_DITHEREDTEXTCLR",
                         HS_SOLIDBKCLR,      "HS_SOLIDBKCLR",
                         HS_DITHEREDBKCLR,   "HS_DITHEREDBKCLR" } ;

     int        i, x, y, cxChar, cyChar ;
     LOGBRUSH   lb ;
     TEXTMETRIC tm ;

     GetTextMetrics (hdc, &tm) ;

     cxChar = tm.tmAveCharWidth ;
     cyChar = tm.tmHeight ;

     SelectObject (hdc, GetStockObject (NULL_PEN)) ;

     for (i = 0 ; i < 25 ; i++)
          {
          x = cxChar * (1 + 40 * (i > 12)) ;
          y = cyChar * (1 +  2 * (i % 13)) ;

          TextOut (hdc, x, y, hatches[i].cLabel,
                      strlen (hatches[i].cLabel)) ;

          x += 24 * cxChar ;

          SetTextColor (hdc, RGB (255,  32,  32)) ;
          SetBkColor   (hdc, RGB ( 32, 255,  32)) ;

          lb.lbStyle = BS_HATCHED ;
          lb.lbColor = RGB (32, 32, 255) ;
          lb.lbHatch = hatches[i].iIdent ;

          SelectObject (hdc, CreateBrushIndirect (&lb)) ;

          Rectangle (hdc, x, y, x + 8 * cxChar, y + cyChar) ;

          SetTextColor (hdc, RGB (  0,   0,   0)) ;
          SetBkColor   (hdc, RGB (255, 255, 255)) ;

          DeleteObject (SelectObject (hdc, GetStockObject (WHITE_BRUSH))) ;
          }
     }
