// CANCEL.CPP Part of VULCAN
// Copyright (c) 1993 John Deurbrouck
#include<windows.h>
#include"resource.h"
#include"vulcan.hpp"
#include"cancel.hpp"
#include"browse.hpp"

static FARPROC lpfnCancelDlgProc=NULL;
static int goner=0;
HWND hCancelDlg=NULL;

BOOL FAR PASCAL _export CancelDlgProc(HWND hDlg,unsigned message,WORD wParam,
LONG lParam){
    switch(message){
    case WM_COMMAND:
        if(IDCANCEL==wParam){
            goner=1;
            DestroyWindow(hDlg);
            hCancelDlg=NULL;
        }
        return TRUE;
    case WM_INITDIALOG:
        EnableMenuItem(GetSystemMenu(hDlg,FALSE),SC_CLOSE,MF_GRAYED);
        SetFocus(GetDlgItem(hDlg,IDCANCEL));
        SetWindowPos(hDlg,0,0,0,0,0,SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOZORDER);
        return FALSE; // because we set focus
    default:
        return FALSE;
    }
}
void start_cancel_dialog_box(void){
    goner=0;
    lpfnCancelDlgProc=MakeProcInstance((int(__far __pascal *)
        (void))CancelDlgProc,hMainInstance);
    hCancelDlg=CreateDialog(hMainInstance,
        MAKEINTRESOURCE(IDD_CANCELVULCANIZE),CURR_WINDOW,lpfnCancelDlgProc); //==++
    if(hCancelDlg!=NULL)EnableWindow(CURR_CANCEL_WINDOW,FALSE);
}
int check_cancel_dialog_box(void){
    MSG msg;
    while(PeekMessage(&msg,NULL,0,0,PM_REMOVE)){
        if((!hCancelDlg)||(!IsDialogMessage(hCancelDlg,&msg))){
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    if(goner)return 1;
    return 0;
}
void set_cancel_dialog_box_text(LPSTR verb,LPSTR object){
    if(hCancelDlg==NULL)return;
    if(verb!=NULL)SetDlgItemText(hCancelDlg,IDC_VERB,verb);
    if(object!=NULL)SetDlgItemText(hCancelDlg,IDC_OBJECT,object);
}
void end_cancel_dialog_box(void){
    if((hCancelDlg!=NULL)&&!goner){
        SendMessage(hCancelDlg,WM_COMMAND,IDCANCEL,0L);
    }
    if(lpfnCancelDlgProc!=NULL)FreeProcInstance(lpfnCancelDlgProc);
    EnableWindow(CURR_CANCEL_WINDOW,TRUE);
}
