* INTEG -- PERFORMS DISCRETE TRAPEZOIDAL INTEGRATION
* (C) Copyright 1994 by James Unterburger.  All rights reserved.
*  -- Version 1.0 1994/02/22
*
* Performs trapezoidal integration of Y array with respect to X array
* INPUT:
* 2:  N-element REAL vector Y of dependent values
* 1:  N-element REAL vector X of independent values,
*     monotonically increasing (else "Invalid Array Element")
*
* OUTPUT:
* 1:  N-element REAL vector I, values of the integral of Y 
*     with respect to X, defined thus:
*
*     I(1) = 0
*
*             K-1
*           1 +--|
*     I(K)= - >    [Y(j+1)+Y(j)]*[X(j+1)-X(j)]       K=2,3,...,N
*           2 +--|
*             j=1
*
TITLE Trapezoidal Integ. of Waveform
ASSEMBLE
   NIBASC  /HPHP48-E/
RPL
::
 CK2NOLASTWD            ( takes two args )
 CK&DISPATCH1
 SIXTYEIGHT             ( two arrays )
 ::
   OVER
   TYPERARRY?           ( is Y real array? )
   OVER
   TYPERARRY?           ( is X real array? )
   AND                  ( both must be real )
   ?SKIP
   SETTYPEERR           ( if not, then "Bad Argument Type" )
   CODE                 ( code to check dims and sizes )
*********************************************************************
* equivalences
invdimerr   = #501  "Invalid Dimension" error number
twotimeflag = 0     "2nd time thru" flag
*********************************************************************

       GOSBVL  =SAVPTR
       ST=0    twotimeflag
       D=0     A
       D=D+1   A                set D.A=00001, valid number of dims
AGAIN  C=DAT1  A                get pointer to array
       D0=C                     put into D0
       D0=D0+  15               point to (#dims)
       C=DAT0  A                get (#dims)
       ?C#D    A                is it not exactly 1 ?
       GOYES   DERR             "Invalid Dimension" error
       D0=D0+  5                point to (dim#1)
       A=DAT0  A                get (dim#1)
       ?ST=1   twotimeflag      2nd time thru?
       GOYES   J1               yes, then skip to J1
       B=A     A                save (dim#1) of X in B.A
       ST=1    twotimeflag      set "2nd time thru" flag
       D1=D1+  5                point to Y
       GONC    AGAIN            loop back to top
J1     ?A#B    A                are Y and X different sizes?
       GOYES   DERR             yes, dims not equal=>error
       GOVLNG  =PUSH#ALOOP      push (dim#1) as system binary; back to RPL
* Note:  GetPtr is defined in the next CODE block
DERR   GOSUB   GetPtr           no, dims not equal
       LC(5)   invdimerr        "Invalid Dimension" error
       GOVLNG  =ErrjmpC
   ENDCODE
   OVER
   TOTEMPOB             ( duplicate X as I [answer] vector )
   NULLHXS
   TWENTYONE
   EXPAND               ( make 21-nibble hexstring for scratch )
   ROT                  ( [ Y X I <hxs> <n> ] on stack )
   CODE
*********************************************************************
* equivalences
invalele  = #502    "Invalid Array Element" error
*********************************************************************
* At entry to this code, stack looks like:
*
*  Y    -- REAL vector of N elements
*  X    -- REAL vector of N elements
*  I    -- REAL vector of N elements
* <hxs> -- hexstring of 21 nibbles
* <N>   -- system binary, N
*
* This code uses the following:
*
* R0.A  = N counter
* R1.A  ->Idata
* R2/R3 = I(K) 15-form extended real
* R4.A  ->hxs data (which holds [X(j+1)-X(j)])
* D1    ->Ydata
* D0    ->Xdata
* RSTK  ->Iprolog
*
       GOSBVL  =POP#            pop N off stack
       R0=A                     and save in R0.A
       D1=D1+  10               drop <hxs> and I
       D=D+1   A
       D=D+1   A               
       GOSBVL  =SAVPTR          save Y and X in case of error
       D1=D1-  10               restore <hxs> and I
       C=DAT1  A                C-> <hxs prolog>
       C=C+CON A,(2*5)          C-> <hxs data>
       R4=C                     save in R4.A
*
       GOSUB   PopArr           A.A->I data
       R1=A                     save ->I data in R1.A
       C=A-C   A                C->Iprolog
       RSTK=C                   save ->I prolog on RSTK
       GOSUB   PopArr           A.A->X data
       D0=A                     D0->X data
       GOSUB   PopArr           A.A->Y data
       D1=A                     D1->Y data
       A=0     W
       R2=A
       R3=A                     initialize I(1)=0
*
TOP    SETHEX
       C=R1
       CD0EX                    D0->I(K)
* write I(K)
       DAT0=A  W
       D0=D0+  16               D0->I(K+1) for next time around
       CD0EX
       R1=C                     R1->I(K+1)
* decr N counter and test
       A=R0
       A=A-1   A
       ?A#0    A
       GOYES   Cont
* exit code
       GOSUB   GetPtr
       D1=D1+  5                drop X vector
       D=D+1   A                
       C=RSTK                   get ->Iprolog
       DAT1=C  A                and overwrite Y with I
       GOVLNG  =Loop            back to RPL
* jump points
GetPtr GOVLNG  =GETPTR
RaddF  GOVLNG  =RADDF
* main loop continues here
Cont   R0=A                     put counter back into R0.A
* X(j+1)-X(j)
       A=DAT0  W                get X(j) into A
       D0=D0+  16               D0->X(j+1)
       C=DAT0  W                get X(j+1) into C
       GOSBVL  =SPLTAC          returns in DEC mode (I hope)
       A=-A-1  S                negate X(j)
       CD0EX                    save D0 on RSTK
       RSTK=C                   because =RADDF uses D0
       CD0EX
       GOSUB   RaddF
****** Remove this block of code if the   *******
****** monotonicity of X is not important *******
       ?A#0    S                test for < zero
       GOYES   NegX
       ?B=0    M                test for == zero
       GOYES   NegX
*************************************************
* sto this to hxs scratch
       C=R4
       D0=C
       GOSBVL  =PUTAB0
* [Y(j)+Y(j+1)]/2
       A=DAT1  W
       D1=D1+  16
       C=DAT1  W
       GOSBVL  =SPLTAC
       GOSUB   RaddF
       GOSBVL  =DIV2
* rcl scratch to C/D
       C=R4
       D0=C
       GOSBVL  =GETCD0
* multiply
       GOSBVL  =MULTF
* get I(K) from R2/R3 and add
       GOSBVL  =RCCD2
       GOSUB   RaddF
* save A/B into R2/R3 and pack into A.W
       GOSBVL  =STAB2           save I(K) in R2/R3
       GOSBVL  =PACK
* restore D0 from RSTK
       C=RSTK
       D0=C
       GOTO    TOP

****** Remove this block of code if the   *******
****** monotonicity of X is not important *******
NegX   GOSUB   GetPtr
       LC(5)   invalele
       SETHEX
       GOVLNG  =ErrjmpC
*************************************************

PopArr
       D1=D1+  5                D1->->prolog
       A=DAT1  A                A.A->prolog
       C=0     A                skip past
       LC(2)   (5*5)            (prolog)(size)(type)(#dims)(dim#1)
       A=A+C   A                point to array (vector) data
       RTNCC                    clear carry
   ENDCODE
 ;
;
*
*     (C) Copyright 1994 by James Unterburger.  All rights reserved.
*
*     Noncommercial distribution allowed, provided that this
*     copyright message is preserved, and any modified versions
*     are clearly marked as such.  
*
*     This program makes use of undocumented low-level features of
*     the HP48 calculator, and may or may not cause loss of data,
*     excessive battery drainage, and/or damage to the calculator
*     hardware.  The Author takes no responsibility whatsoever for 
*     any damage caused by the use of this program.
*
*     THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
*     IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* Bug reports, enhancement requests, praise, and damnation are always 
* appreciated {8)
*==============================================================================
* James Unterburger                  e-mail: jamesu@anacad.fr
* Tempologis Flat 215
* 2-bis Chemin des Preles
* 38240 Meylan FRANCE
*==============================================================================


